/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.admin.ProjectAdminSidebarFeature;
import com.atlassian.jira.plugin.webfragment.JiraWebInterfaceManager;
import com.atlassian.jira.plugin.webfragment.descriptors.JiraWebItemModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.JiraWebLabel;
import com.atlassian.jira.plugin.webfragment.model.JiraWebLink;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeIconRenderer;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeyFormatter;
import com.atlassian.jira.project.type.warning.InaccessibleProjectTypeDialogDataProvider;
import com.atlassian.jira.projectconfig.beans.SimpleProject;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HeaderContextProvider
implements ContextProvider {
    static final String CONTEXT_SIDEBAR_PRESENT = "isSidebarPresent";
    static final String CONTEXT_PROJECT_KEY = "project";
    static final String CONTEXT_IS_ADMIN_KEY = "isAdmin";
    static final String CONTEXT_I18N_KEY = "i18n";
    static final String CONTEXT_SIMPLE_PROJECT_KEY = "simpleProject";
    static final String CONTEXT_VIEW_PROJECT_OPERATIONS_KEY = "viewableProjectOperations";
    static final String CONTEXT_PROJECT_LEAD_EXISTS_KEY = "projectLeadExists";
    static final String CURRENT_TAB = "admin.active.tab";
    static final String SHOW_ACTIONS_MENU = "showActionsMenu";
    static final String PROJECT_TYPE_KEY = "projectTypeKey";
    static final String PROJECT_TYPE_NAME = "projectTypeName";
    static final String PROJECT_TYPE_ICON = "projectTypeIcon";
    static final String SHOULD_DISPLAY_PROJECT_TYPE_WARNING = "displayProjectTypeWarning";
    private final JiraWebInterfaceManager jiraWebInterfaceManager;
    private final ContextProviderHelper contextProviderHelper;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectTypeIconRenderer projectTypeIconRenderer;
    private final InaccessibleProjectTypeDialogDataProvider inaccessibleProjectTypeDialogDataProvider;
    private final ProjectAdminSidebarFeature projectAdminSidebarFeature;

    public HeaderContextProvider(WebInterfaceManager webInterfaceManager, ContextProviderHelper contextProviderHelper, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport ProjectTypeIconRenderer projectTypeIconRenderer, @ComponentImport InaccessibleProjectTypeDialogDataProvider inaccessibleProjectTypeDialogDataProvider, @ComponentImport ProjectAdminSidebarFeature projectAdminSidebarFeature) {
        this.jiraWebInterfaceManager = new JiraWebInterfaceManager(webInterfaceManager);
        this.contextProviderHelper = contextProviderHelper;
        this.authenticationContext = authenticationContext;
        this.projectTypeIconRenderer = projectTypeIconRenderer;
        this.inaccessibleProjectTypeDialogDataProvider = inaccessibleProjectTypeDialogDataProvider;
        this.projectAdminSidebarFeature = projectAdminSidebarFeature;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder contextBuilder = MapBuilder.newBuilder(context);
        ApplicationUser user = this.contextProviderHelper.getAuthenticationContext().getLoggedInUser();
        Project project = (Project)context.get(CONTEXT_PROJECT_KEY);
        SimpleProject wrappedProject = new SimpleProject(project);
        this.addProjectTypeInformation((MapBuilder<String, Object>)contextBuilder, project);
        contextBuilder.add((Object)CONTEXT_SIDEBAR_PRESENT, (Object)this.projectAdminSidebarFeature.shouldDisplay());
        contextBuilder.add((Object)SHOW_ACTIONS_MENU, (Object)this.isSummaryTab(context));
        contextBuilder.add((Object)CONTEXT_SIMPLE_PROJECT_KEY, (Object)wrappedProject);
        contextBuilder.add((Object)CONTEXT_PROJECT_LEAD_EXISTS_KEY, (Object)UserUtils.userExists((String)project.getLeadUserName()));
        contextBuilder.add((Object)CONTEXT_IS_ADMIN_KEY, (Object)this.contextProviderHelper.hasAdminPermission());
        contextBuilder.add((Object)CONTEXT_I18N_KEY, (Object)this.contextProviderHelper.getI18nHelper());
        this.addOperations(user, project, (MapBuilder<String, Object>)contextBuilder);
        return this.createContext(contextBuilder.toMap());
    }

    private void addProjectTypeInformation(MapBuilder<String, Object> contextBuilder, Project project) {
        ProjectTypeKey projectTypeKey = project.getProjectTypeKey();
        contextBuilder.add((Object)PROJECT_TYPE_KEY, (Object)projectTypeKey.getKey());
        contextBuilder.add((Object)PROJECT_TYPE_NAME, (Object)ProjectTypeKeyFormatter.format((ProjectTypeKey)projectTypeKey));
        contextBuilder.add((Object)PROJECT_TYPE_ICON, this.projectTypeIconRenderer.getIconToRender(projectTypeKey).orElse(null));
        contextBuilder.add((Object)SHOULD_DISPLAY_PROJECT_TYPE_WARNING, (Object)this.shouldDisplayProjectTypeWarning(project));
    }

    private boolean shouldDisplayProjectTypeWarning(Project project) {
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        return this.inaccessibleProjectTypeDialogDataProvider.shouldDisplayInaccessibleWarning(loggedInUser, project);
    }

    private boolean isSummaryTab(Map<String, Object> context) {
        return "view_project_summary".equals(context.get(CURRENT_TAB)) || "summary".equals(context.get("atl.jira.admin.current.project.tab"));
    }

    private void addOperations(ApplicationUser user, Project project, MapBuilder<String, Object> ctx) {
        JiraHelper jiraHelper = this.getJiraHelper(project);
        List displayableItems = this.jiraWebInterfaceManager.getDisplayableItems("system.view.project.operations", user, jiraHelper);
        ArrayList<SimpleViewableProjectOperation> ops = new ArrayList<SimpleViewableProjectOperation>();
        for (WebItemModuleDescriptor displayableItem : displayableItems) {
            JiraWebItemModuleDescriptor jiraDisplayableItem = (JiraWebItemModuleDescriptor)displayableItem;
            SimpleViewableProjectOperation operation = this.createViewableProjectOperation(jiraDisplayableItem, user, jiraHelper);
            ops.add(operation);
        }
        ctx.add((Object)CONTEXT_VIEW_PROJECT_OPERATIONS_KEY, ops);
    }

    private SimpleViewableProjectOperation createViewableProjectOperation(JiraWebItemModuleDescriptor displayableItem, ApplicationUser user, JiraHelper jiraHelper) {
        JiraWebLink link = (JiraWebLink)displayableItem.getLink();
        JiraWebLabel jiraWebLabel = (JiraWebLabel)displayableItem.getLabel();
        String displayableUrl = this.getUrlEncodedRenderedUrl(link.getRenderedUrl(user, jiraHelper));
        String displayableLabel = jiraWebLabel.getDisplayableLabel(user, jiraHelper);
        return new SimpleViewableProjectOperation(link.getId(), displayableUrl, displayableLabel, displayableItem.getStyleClass());
    }

    JiraHelper getJiraHelper(Project project) {
        return new JiraHelper(ExecutingHttpRequest.get(), project);
    }

    String getUrlEncodedRenderedUrl(String renderedUrl) {
        return this.contextProviderHelper.createUrlBuilder(renderedUrl).asUrlString();
    }

    Map<String, Object> createContext(Map<String, Object> params) {
        return JiraVelocityUtils.getDefaultVelocityParams(params, (JiraAuthenticationContext)this.contextProviderHelper.getAuthenticationContext());
    }

    public static class SimpleViewableProjectOperation {
        private final String linkId;
        private final String displayableUrl;
        private final String displayableLabel;
        private final String styleClass;

        public SimpleViewableProjectOperation(String linkId, String displayableUrl, String displayableLabel, String styleClass) {
            this.linkId = linkId;
            this.displayableUrl = displayableUrl;
            this.displayableLabel = displayableLabel;
            this.styleClass = styleClass;
        }

        public String getLinkId() {
            return this.linkId;
        }

        public String getDisplayableUrl() {
            return this.displayableUrl;
        }

        public String getDisplayableLabel() {
            return this.displayableLabel;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleViewableProjectOperation that = (SimpleViewableProjectOperation)o;
            if (this.displayableLabel != null ? !this.displayableLabel.equals(that.displayableLabel) : that.displayableLabel != null) {
                return false;
            }
            if (this.styleClass != null ? !this.styleClass.equals(that.styleClass) : that.styleClass != null) {
                return false;
            }
            if (this.displayableUrl != null ? !this.displayableUrl.equals(that.displayableUrl) : that.displayableUrl != null) {
                return false;
            }
            return !(this.linkId != null ? !this.linkId.equals(that.linkId) : that.linkId != null);
        }

        public int hashCode() {
            int result = this.linkId != null ? this.linkId.hashCode() : 0;
            result = 31 * result + (this.displayableUrl != null ? this.displayableUrl.hashCode() : 0);
            result = 31 * result + (this.displayableLabel != null ? this.displayableLabel.hashCode() : 0);
            result = 31 * result + (this.styleClass != null ? this.styleClass.hashCode() : 0);
            return result;
        }
    }
}

