/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.NamedDefault;
import com.atlassian.jira.projectconfig.beans.SimpleFieldConfigScheme;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.util.TabUrlFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class FieldsSummaryPanelContextProvider
implements CacheableContextProvider {
    static final String CONTEXT_FIELD_CONFIG_SCHEME_KEY = "fieldConfigScheme";
    static final String CONTEXT_FIELD_CONFIGS_KEY = "fieldConfigs";
    private final FieldLayoutManager fieldLayoutManager;
    private final ContextProviderUtils contextProviderUtils;
    private final TabUrlFactory tabUrlFactory;
    private final OrderFactory orderFactory;

    public FieldsSummaryPanelContextProvider(FieldLayoutManager fieldLayoutManager, ContextProviderUtils contextProviderUtils, TabUrlFactory tabUrlFactory, OrderFactory orderFactory) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.contextProviderUtils = contextProviderUtils;
        this.tabUrlFactory = tabUrlFactory;
        this.orderFactory = orderFactory;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ArrayList fieldConfigs;
        SimpleFieldConfigScheme fieldConfigScheme;
        Project project = (Project)context.get("project");
        I18nHelper i18nHelper = (I18nHelper)context.get("i18n");
        List fieldLayoutSchemes = this.fieldLayoutManager.getFieldLayoutSchemes();
        FieldConfigurationScheme fieldConfigurationScheme = this.fieldLayoutManager.getFieldConfigurationScheme(project);
        if (fieldLayoutSchemes == null || fieldLayoutSchemes.size() == 0 || fieldConfigurationScheme == null) {
            fieldConfigScheme = this.getDefaultFieldConfigScheme(project, i18nHelper);
            fieldConfigs = Collections.singletonList(SimpleFieldConfig.getSystemDefaultSimpleFieldConfig(this.getSystemDefaultEditConfigUrl(), true));
        } else {
            fieldConfigScheme = new SimpleFieldConfigScheme(fieldConfigurationScheme, null, this.getEditSchemeUrl());
            fieldConfigs = Lists.newArrayList(this.getSimpleFieldConfigs(project, fieldConfigurationScheme));
        }
        return MapBuilder.newBuilder().addAll(context).add((Object)CONTEXT_FIELD_CONFIG_SCHEME_KEY, (Object)fieldConfigScheme).add((Object)CONTEXT_FIELD_CONFIGS_KEY, (Object)fieldConfigs).toMap();
    }

    private Set<SimpleFieldConfig> getSimpleFieldConfigs(Project project, FieldConfigurationScheme fieldConfigurationScheme) {
        TreeSet fieldConfigs = Sets.newTreeSet(this.orderFactory.createNamedDefaultComparator());
        Long defaultFieldLayoutId = fieldConfigurationScheme.getFieldLayoutId(null);
        if (defaultFieldLayoutId == null) {
            defaultFieldLayoutId = this.fieldLayoutManager.getFieldLayout().getId();
        }
        for (IssueType issueType : project.getIssueTypes()) {
            boolean isDefaultFieldConfig;
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(project, issueType.getId());
            if (fieldLayout == null || fieldLayout.getId() == null) {
                isDefaultFieldConfig = defaultFieldLayoutId == null;
                fieldConfigs.add(SimpleFieldConfig.getSystemDefaultSimpleFieldConfig(this.getSystemDefaultEditConfigUrl(), isDefaultFieldConfig));
                continue;
            }
            isDefaultFieldConfig = fieldLayout.getId().equals(defaultFieldLayoutId);
            fieldConfigs.add(new SimpleFieldConfig(fieldLayout, this.getFieldConfigUrl(fieldLayout.getId()), isDefaultFieldConfig));
        }
        return fieldConfigs;
    }

    String getEditSchemeUrl() {
        return this.tabUrlFactory.forFields();
    }

    String getFieldConfigUrl(Long id) {
        return this.createUrlBuilder("/secure/admin/ConfigureFieldLayout!default.jspa").addParameter("id", (Object)id).asUrlString();
    }

    String getSystemDefaultEditConfigUrl() {
        return this.createUrlBuilder("/secure/admin/ViewIssueFields.jspa").asUrlString();
    }

    private UrlBuilder createUrlBuilder(String operation) {
        return this.contextProviderUtils.createUrlBuilder(operation);
    }

    private SimpleFieldConfigScheme getDefaultFieldConfigScheme(Project project, I18nHelper i18nHelper) {
        return new SimpleFieldConfigScheme(null, i18nHelper.getText("admin.projects.system.default.field.config"), "", null, this.getEditSchemeUrl());
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public static class SimpleFieldConfig
    implements NamedDefault {
        private final Long id;
        private final String name;
        private final String description;
        private final String url;
        private final boolean defaultFieldConfig;

        public static SimpleFieldConfig getSystemDefaultSimpleFieldConfig(String url, boolean defaultFieldconfig) {
            return new SimpleFieldConfig(null, "Default Field Configuration", "The default field configuration", url, defaultFieldconfig);
        }

        public SimpleFieldConfig(FieldLayout fieldLayout, String url, boolean defaultFieldConfig) {
            this.id = fieldLayout.getId();
            this.name = fieldLayout.getName();
            this.description = fieldLayout.getDescription();
            this.url = url;
            this.defaultFieldConfig = defaultFieldConfig;
        }

        SimpleFieldConfig(Long id, String name, String description, String url, boolean defaultFieldConfig) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.url = url;
            this.defaultFieldConfig = defaultFieldConfig;
        }

        public Long getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefaultFieldConfig();
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isDefaultFieldConfig() {
            return this.defaultFieldConfig;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleFieldConfig that = (SimpleFieldConfig)o;
            if (this.defaultFieldConfig != that.defaultFieldConfig) {
                return false;
            }
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            result = 31 * result + (this.defaultFieldConfig ? 1 : 0);
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

