/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.util.UrlEncoder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextProviderHelper {
    private final UrlEncoder encoder;
    private final PermissionManager permissionManager;
    private final VelocityRequestContextFactory requestContextFactory;
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public ContextProviderHelper(UrlEncoder urlEncoder, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, VelocityRequestContextFactory requestContextFactory) {
        this.encoder = urlEncoder;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.requestContextFactory = requestContextFactory;
    }

    public String encode(String value) {
        return this.encoder.encode(value);
    }

    public boolean hasProjectAdminPermission(Project project) {
        return this.permissionManager.hasPermission(23, project, this.authenticationContext.getLoggedInUser());
    }

    public boolean hasAdminPermission() {
        return this.permissionManager.hasPermission(0, this.authenticationContext.getLoggedInUser());
    }

    public I18nHelper getI18nHelper() {
        return this.authenticationContext.getI18nHelper();
    }

    public JiraAuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public UrlBuilder createUrlBuilder(String basename) {
        return new UrlBuilder(this.getBaseUrl() + StringUtils.stripToEmpty((String)basename));
    }

    public String getBaseUrl() {
        return this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }
}

