/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentService;
import com.atlassian.jira.plugin.profile.UserFormat;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.util.TabUrlFactory;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ComponentsSummaryPanelContextProvider
implements CacheableContextProvider {
    private static final String COMPONENT_SUMMARY_ID = "component-summary-panel-lead";
    private static final int MAX_COMPONENTS_DISPLAYED = 5;
    private final ContextProviderUtils providerUtils;
    private final ProjectComponentService projectComponentService;
    private final UserFormats userFormatManager;
    private final TabUrlFactory tabUrlFactory;

    public ComponentsSummaryPanelContextProvider(ContextProviderUtils providerUtils, ProjectComponentService projectComponentService, UserFormats userFormatManager, TabUrlFactory tabUrlFactory) {
        this.providerUtils = providerUtils;
        this.projectComponentService = projectComponentService;
        this.userFormatManager = userFormatManager;
        this.tabUrlFactory = tabUrlFactory;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        int count;
        Project project = this.providerUtils.getProject();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ArrayList components = Lists.newArrayList((Iterable)this.projectComponentService.findAllForProject((ErrorCollection)errorCollection, project.getId()));
        ArrayList<SimpleComponent> simpleComponents = new ArrayList<SimpleComponent>(5);
        int totalSize = components.size();
        UserFormat format = this.userFormatManager.forType("profileLink");
        Iterator iterator = components.iterator();
        for (count = 0; count < 5 && iterator.hasNext(); ++count) {
            ProjectComponent component = (ProjectComponent)iterator.next();
            String userHover = component.getLead() != null ? format.format(component.getLead(), COMPONENT_SUMMARY_ID) : null;
            simpleComponents.add(new SimpleComponent(component.getName(), userHover));
        }
        MapBuilder newContext = MapBuilder.newBuilder(context).add((Object)"components", simpleComponents).add((Object)"errors", this.providerUtils.flattenErrors((ErrorCollection)errorCollection)).add((Object)"totalSize", (Object)totalSize).add((Object)"actualSize", (Object)count).add((Object)"manageUrl", (Object)this.tabUrlFactory.forComponents());
        return newContext.toMap();
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public static class SimpleComponent {
        private final String name;
        private final String userHover;

        SimpleComponent(String name, String userHover) {
            this.name = name;
            this.userHover = userHover;
        }

        public String getName() {
            return this.name;
        }

        public String getUserHoverHtml() {
            return this.userHover;
        }

        public boolean isHasLead() {
            return this.userHover != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleComponent that = (SimpleComponent)o;
            return this.name.equals(that.name) && !(this.userHover == null ? that.userHover != null : !this.userHover.equals(that.userHover));
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.userHover != null ? this.userHover.hashCode() : 0);
            return result;
        }
    }
}

