/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.beans;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.user.ApplicationUser;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class SimpleProject {
    private final Long id;
    private final String key;
    private final String name;
    private final String url;
    private final ProjectCategory projectCategory;
    private final String description;
    private final Avatar avatar;
    private final ApplicationUser lead;

    public SimpleProject(Project project) {
        this.key = project.getKey();
        this.id = project.getId();
        this.name = project.getName();
        this.url = project.getUrl();
        this.description = project.getDescription();
        this.projectCategory = project.getProjectCategoryObject();
        this.avatar = project.getAvatar();
        this.lead = project.getProjectLead();
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAbbreviatedUrl() {
        return StringUtils.abbreviate((String)this.url, (int)60);
    }

    public ProjectCategory getProjectCategory() {
        return this.projectCategory;
    }

    public String getDescriptionHtml() {
        return this.description;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public ApplicationUser getLead() {
        return this.lead;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleProject that = (SimpleProject)o;
        if (this.avatar != null ? !this.avatar.getId().equals(that.avatar.getId()) : that.avatar != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.key.equals(that.key)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.projectCategory != null ? !this.projectCategory.equals(that.projectCategory) : that.projectCategory != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.key.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.projectCategory != null ? this.projectCategory.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.avatar != null ? this.avatar.getId().hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

