/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.projectconfig.analytics.AnalyticsJob;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class AnalyticsScheduler
implements LifecycleAware {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsScheduler.class);
    private static final String JOB_KEY = AnalyticsScheduler.class.getName();
    private static final JobId JOB_ID = JobId.of((String)AnalyticsScheduler.class.getName());
    private static final long SCHEDULER_INTERVAL = 604800000L;
    private final SchedulerService schedulerService;
    private final ProjectManager projectManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowManager workflowManager;
    private final EventPublisher eventPublisher;

    @Autowired
    public AnalyticsScheduler(@ComponentImport SchedulerService schedulerService, @ComponentImport ProjectManager projectManager, @ComponentImport WorkflowSchemeManager workflowSchemeManager, @ComponentImport WorkflowManager workflowManager, @ComponentImport EventPublisher eventPublisher) {
        this.projectManager = projectManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.workflowManager = workflowManager;
        this.eventPublisher = eventPublisher;
        this.schedulerService = schedulerService;
    }

    private JobConfig getJobConfig() {
        return JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)JOB_KEY)).withSchedule(Schedule.forInterval((long)604800000L, (Date)new Date(System.currentTimeMillis() + 3600000L)));
    }

    public void onStart() {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)JOB_KEY);
        LOG.trace("Registering and scheduling AnalyticsJob");
        this.schedulerService.registerJobRunner(jobRunnerKey, (JobRunner)new AnalyticsJob(this.projectManager, this.workflowSchemeManager, this.workflowManager, this.eventPublisher));
        try {
            this.schedulerService.scheduleJob(JOB_ID, this.getJobConfig());
            LOG.trace("AnalyticsJob schedule successfully completed");
        }
        catch (SchedulerServiceException e) {
            LOG.error("Error was thrown during scheduling an AnalyticsJob", (Throwable)e);
        }
    }

    public void onStop() {
        this.schedulerService.unscheduleJob(JOB_ID);
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)JOB_KEY);
        this.schedulerService.unregisterJobRunner(jobRunnerKey);
    }
}

