/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.analytics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.workflow.DefaultWorkflowService;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.projectconfig.event.WorkflowsStatisticEvent;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsJob
implements JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsJob.class);
    private final ProjectManager projectManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowManager workflowManager;
    private final EventPublisher eventPublisher;

    public AnalyticsJob(ProjectManager projectManager, WorkflowSchemeManager workflowSchemeManager, WorkflowManager workflowManager, EventPublisher eventPublisher) {
        this.projectManager = projectManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.workflowManager = workflowManager;
        this.eventPublisher = eventPublisher;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        LOG.trace("Counting workflow statistics");
        Map<String, Long> workflowProjectOccurrence = this.projectManager.getProjects().stream().map(p -> {
            Map workflowMap = DefaultWorkflowService.ADD_DEFAULT_WORKFLOW_IF_MISSING((Map)this.workflowSchemeManager.getWorkflowMap(p));
            String defaultWorkflowName = (String)workflowMap.get(null);
            return p.getIssueTypes().stream().map(it -> (String)workflowMap.get(it.getId())).map(wf -> Objects.isNull(wf) ? defaultWorkflowName : wf).distinct().collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.groupingBy(wf -> wf, Collectors.counting()));
        long usedWorkflowsCount = workflowProjectOccurrence.size();
        long isolatedWorkflowsCount = workflowProjectOccurrence.entrySet().stream().filter(entry -> (Long)entry.getValue() == 1L).count();
        long sharedWorkflowsCount = usedWorkflowsCount - isolatedWorkflowsCount;
        long inactiveWorkflowsCount = this.workflowManager.getWorkflows().size() - this.workflowManager.getActiveWorkflows().size();
        long totalWorkflowsCount = inactiveWorkflowsCount + usedWorkflowsCount;
        this.eventPublisher.publish((Object)new WorkflowsStatisticEvent(totalWorkflowsCount, isolatedWorkflowsCount, sharedWorkflowsCount, inactiveWorkflowsCount));
        LOG.trace("Workflows statistics send");
        return JobRunnerResponse.success();
    }
}

