define('jira/admin-helper/whereismycf/ui', [
    'jquery',
    'jira/ajs/list/group-descriptor',
    'jira/ajs/list/item-descriptor',
    'jira/ajs/select/queryable-dropdown-select',
    'jira/ajs/ajax/smart-ajax'
], function (
    $,
    GroupDescriptor,
    ItemDescriptor,
    QueryableDropdownSelect,
    SmartAjax
) {
    return {

        _formatActionsResponse: function (response) {

            var res = [];

            if (response) {
                var group = new GroupDescriptor({
                    showLabel: false,
                    label: AJS.I18n.getText("whereismycf.dialog.allfields")
                });
                $(response).each(function () {
                    var desc = new ItemDescriptor({
                        label: this.customFieldName
                    });
                    desc.properties.cfId = this.customFieldId;
                    group.addItem(desc);
                });
                res.push(group);
            }

            return res;
        },

        initUi: function ($content, context, onContentAdded) {

            var queryControl = new QueryableDropdownSelect({
                id: "whereismycf",
                element: $content.find("#whereismycf-suggestions"),
                ajaxOptions: {
                    minQueryLength: 1,
                    dataType: "json",
                    url: contextPath + "/rest/whereismycf/1.0/fields/all",
                    formatResponse: this._formatActionsResponse
                },
                showDropdownButton: true,
                loadOnInit: true // TODO sure about that?
            });
            queryControl._handleServerError = function (smartAjaxResult) {
                var errMsg = SmartAjax.buildSimpleErrorContent(smartAjaxResult);
                var errorClass = smartAjaxResult.status === 401 ? 'warning' : 'error';
                $content.html($(JIRA.Templates.Dialogs.WhereIsMyCf.errorPage({
                    errrorMessage: errMsg,
                    errorClass: errorClass
                })));
            };
            var originalHandler = queryControl.listController.options.selectionHandler;
            queryControl.listController.options.selectionHandler = function (event) {
                // use built-in handler from the queryControl
                // this refers to the instance of AJS.List
                originalHandler.call(this, event);
                $content.find(".field-status-results").remove();
                $content.find(".field-status-placeholder").append($(JIRA.Templates.AdminHelper.Common.loadingStatus()));
                var customField = this.getFocused().data("descriptor");
                AJS.trigger('analyticsEvent', {name: 'adminhelper.whereismycf.field.select'});
                SmartAjax.makeRequest({
                    url: contextPath + AJS.format(
                        "/rest/whereismycf/1.0/fields/{0}?{1}",
                        customField.properties.cfId,
                        context.asRequestParams()),
                    complete: function (xhr, textStatus, smartAjaxResult) {
                        if (smartAjaxResult.successful) {
                            // reset the dropdown field
                            queryControl.$field.val("").css("color", "black");
                            // remove the loading status
                            $content.find(".status-loading").remove();
                            var fieldInfo = smartAjaxResult.data;
                            $content.find(".field-status-placeholder").append($(JIRA.Templates.Dialogs.WhereIsMyCf.resultPage({
                                fieldName: customField.label(),
                                issueType: fieldInfo.issueType,
                                issueKey: fieldInfo.issueKey,
                                project: fieldInfo.projectName,
                                operation: fieldInfo.operation,
                                status: fieldInfo.status,
                                statusLines: processStatusLines(fieldInfo.statusLines),
                                baseUrl: contextPath
                            })));
                        } else {
                            handleError(smartAjaxResult);
                        }
                        onContentAdded();
                    }
                });
                return false;
            };

            function processStatusLines(statusLines) {
                if (statusLines.length == 0) {
                    return statusLines;
                }

                function processMessages(messages) {
                    var processedMsgs = [];
                    $.each(messages, function (index, message) {
                        processedMsgs.push(processMessage(message));
                    });
                    return processedMsgs;
                }

                function processMessage(message) {
                    if (message.parameters.length == 0) {
                        return AJS.escapeHTML(message.message);
                    } else {
                        var args = processParams(message.parameters);
                        // need to call AJS.format using apply cause all we have is an array of arguments
                        args.splice(0, 0, AJS.escapeHTML(message.message));
                        return AJS.format.apply(this, args);
                    }
                }

                function processParams(params) {
                    var result = [];
                    $.each(params, function (index, param) {
                        if (param.type == "plain") {
                            result.push(AJS.escapeHTML(param.value));
                        } else if (param.type == "link") {
                            result.push(AJS.format("<a href=''{0}'' target=''_blank''>{1}</a>", AJS.escapeHTML(param.href), AJS.escapeHTML(param.text)));
                        } else if (param.type == "newline") {
                            result.push("<br/>");
                        } else if (param.type == "tagstart") {
                            result.push("<" + param.tagName + ">");
                        } else if (param.type == "tagend") {
                            result.push("</" + param.tagName + ">");
                        } else {
                            throw "Unrecognized parameter type: " + param.type;
                        }
                    });
                    return result;
                }

                var processed = [];
                $.each(statusLines, function (index, statusLine) {
                    var newStatus = {};
                    newStatus.status = statusLine.status;
                    newStatus.summary = processMessages(statusLine.summary);
                    newStatus.details = processMessages(statusLine.details);
                    processed.push(newStatus);
                });
                return processed;
            }

            function handleError(smartAjaxResult) {
                var errorMessages = [];
                var errMsg = SmartAjax.buildSimpleErrorContent(smartAjaxResult);
                if (errMsg) {
                    errorMessages.push(errMsg);
                } else {
                    if (smartAjaxResult.data && smartAjaxResult.data.errorMessages) {
                        errorMessages.push(smartAjaxResult.data.errorMessages);
                    }
                    if (smartAjaxResult.data && smartAjaxResult.data.errors) {
                        errorMessages.push(smartAjaxResult.data.errors);
                    }
                }
                var errorClass = smartAjaxResult.status === 401 ? 'warning' : 'error';
                $content.html($(JIRA.Templates.Dialogs.WhereIsMyCf.errorPage({
                    errorMessages: errorMessages,
                    errorClass: errorClass
                })));
            }
        }
    };
});
