define('jira/admin-helper/whereismycf/content-loader', [
    'jquery',
    'jira/admin-helper/context',
    'jira/admin-helper/whereismycf/ui'
], function (
    $,
    Context,
    HelperUi
) {
    var OPERATION_CREATE = 0;
    var OPERATION_EDIT = 1;
    var OPERATION_VIEW = 2;

    return {
        loadContentForView: function loadContentForView(dialog, callback) {
            AJS.trigger('analyticsEvent', {name: 'adminhelper.whereismycf.dialog.open'});
            dialog.addHeading(AJS.I18n.getText("whereismycf.dialog.title"));
            dialog.onContentReady(function onContentReady() {
                HelperUi.initUi(dialog.get$popupContent(), createViewContext(), function () {
                    dialog._positionInCenter();
                });
            });

            callback($(JIRA.Templates.Dialogs.WhereIsMyCf.searchPage()));
        },

        loadContentForEditAndCreate: function loadContentForEditAndCreate(dialog, currentDialog, callback) {
            AJS.trigger('analyticsEvent', {name: 'adminhelper.whereismycf.dialog.open.quickedit'});
            dialog.addHeading(AJS.I18n.getText("whereismycf.dialog.title"));
            dialog.onContentReady(function onContentReady() {
                HelperUi.initUi(dialog.get$popupContent(), createQfContext(currentDialog), function () {
                    dialog._positionInCenter();
                });
            });

            callback($(JIRA.Templates.Dialogs.WhereIsMyCf.searchPage()));
        }
    };

    function getIssueKey() {
        var issueKey = JIRA.Issue.getIssueKey();
        if (!issueKey && JIRA.IssueNavigator) {
            issueKey = JIRA.IssueNavigator.getSelectedIssueKey();
        }
        return issueKey;
    }

    function createViewContext() {
        return new Context({
            issueKey: getIssueKey(),
            issueOperation: OPERATION_VIEW
        });
    }

    function createQfContext(currentDialog) {
        switch(currentDialog.options.id) {
            case "create-issue-dialog":
            case "create-subtask-dialog":
            case "prefillable-create-issue-dialog":
                return createQfCreateContext(currentDialog);
                break;
            case "edit-issue-dialog":
                return createQfEditContext(currentDialog);
                break;
            default:
                throw "Uknown current dialog ID: " + currentDialog.options.id;
                break;
        }
    }

    function createQfCreateContext(currentDialog) {
        var contents = currentDialog.get$popupContent();
        return new Context({
            projectId: contents.find("#project").val(),
            issueTypeId: contents.find("#issuetype").val(),
            issueOperation: OPERATION_CREATE
        });
    }

    function createQfEditContext(currentDialog) {
        var contents = currentDialog.get$popupContent();
        return new Context({
            issueKey: getIssueKey(),
            issueTypeId: contents.find("#issuetype").val(),
            issueOperation: OPERATION_EDIT
        });
    }
});
