require([
    'jquery',
    'jira/admin-helper/dialog',
    'jira/util/data/meta',
    'jira/dialog/dialog'
], function (
    $,
    Dialog,
    Meta,
    JiraDialog
) {
    if (Meta.get("is-admin")) {
        var LABEL = AJS.I18n.getText('whereismycf.dialog.title');

        $(document).delegate(".whereismycf-trigger", "click", function (event) {
            event.preventDefault();
            new Dialog({
                id: "whereismycf-dialog",
                content: function content(callback) {
                    var dialog = this;
                    require(['jira/admin-helper/whereismycf/content-loader'],
                        function (ContentLoader) {
                            ContentLoader.loadContentForView(dialog, callback);
                        });
                }
            }).show();

        });
        // hook into the quick-edit
        $(document).bind("showLayer", function (event, control, hash) {
            if (control == "inlineDialog" && hash.popup.attr("id") == "inline-dialog-field_picker_popup") {
                if (hash.popup.find(".whereismycf-qfpicker-link").length == 0) {
                    var thelink = $("<a href='#' class='whereismycf-qfpicker-link'>" + LABEL + "</a>").appendTo(hash.popup.find(".qf-picker-header dl"));
                    thelink.click(function (event) {
                        event.preventDefault();
                        hash.hide();
                        eventsAndDecouplingInJavaScriptAreSoooAwesome();
                        var currentDialog = JiraDialog.current;
                        new Dialog({
                            id: "whereismycf-dialog",
                            content: function content(callback) {
                                var dialog = this;
                                require(['jira/admin-helper/whereismycf/content-loader'],
                                    function (ContentLoader) {
                                        ContentLoader.loadContentForEditAndCreate(dialog, currentDialog, callback);
                                    });
                            }
                        }).show();

                    });
                }
            }
        });

        function eventsAndDecouplingInJavaScriptAreSoooAwesome() {
            // we're doing this because LayerManager wants to outsmart the world by deciding what to hide and what not...
            // and InlineDialog (and everything else in AUI) wants to outsmart the world by applying stupid timeouts to everything...
            // but ultimately you can outsmart every smartass in the JS land just by setting global variables to null! BUAHAHAHAHAHAHA
            AJS.InlineDialog.current = null;
        }
    }
});