require([
    'jquery',
    'jira/ajs/dark-features',
    'jira/util/data/meta',
    'jira/util/events',
    'jira/util/events/types',
    'jira/util/events/reasons'
], function (
    $,
    DarkFeatures,
    Meta,
    JiraEvents,
    JiraEventTypes,
    JiraEventReasons
) {
    if (Meta.get("is-admin")) {
        $(function () {
            JiraEvents.bind(JiraEventTypes.NEW_CONTENT_ADDED, function(types, context, reason) {
                // new edit project permissions page
                if (isOnNewEditPermissionsPage(context, reason)) {
                    var $header = getHeaderPluginPointOnNewEditPermissionsPage();
                    $header.find(".aui-buttons").append($(JIRA.Templates.Nav.PermissionHelper.editPermissionsNavButton()));
                    showHelpTip($("#permission-helper-button"));
                }
            });

            if (isOnEditPermissionsPage()) {
                var $header = getHeaderOnEditPermissionsPage();
                $header.find(".aui-buttons").append($(JIRA.Templates.Nav.PermissionHelper.editPermissionsNavButton()));
                showHelpTip($("#permission-helper-button"));
            }
            else if (isOnViewPermissionsPage()) {
                var $opMenu = getOperationMenuOnViewPermissionsPage();
                // operations menu may be hidden
                if ($opMenu.length == 1) {
                    $opMenu.prepend($(JIRA.Templates.Nav.PermissionHelper.viewPermissionsNavButton()));
                    showHelpTip($("#permission-helper-button"));
                }
            }
        });

        function isOnNewEditPermissionsPage(context, reason) {
            return typeof context !== 'undefined' && typeof context.is === 'function' && context.is('.project-permissions-container') && reason === JiraEventReasons.pageLoad;
        }

        function isOnEditPermissionsPage() {
            var $el = $("#edit_project_permissions");
            return ($el.length >= 1);
        }

        function isOnViewPermissionsPage() {
            var $el = $("#project-config-panel-permissions");
            return ($el.length >= 1);
        }

        function getHeaderOnEditPermissionsPage() {
            var $header = $(".aui-page-panel-content > header");
            if ($header.length == 0) {
                $header = $(JIRA.Templates.Nav.PermissionHelper.permissionHelperTriggerContainer());
                $(".aui-page-panel-content").prepend($header);
            }
            return $header;
        }

        function getHeaderPluginPointOnNewEditPermissionsPage() {
            var $header = $(".admin-header-actions-plugin-point");
            var $actionsContainer = $(JIRA.Templates.Nav.PermissionHelper.permissionHelperTriggerContainer());
            $header.prepend($actionsContainer);
            return $actionsContainer;
        }

        function getOperationMenuOnViewPermissionsPage() {
            if (DarkFeatures.isEnabled('com.atlassian.jira.config.PDL')) {
                var pageActionsContainer = $("#project-config-panel-permissions > .aui-page-header .aui-page-header-actions");
                var existingButtons = pageActionsContainer.find(".aui-buttons");
                return (existingButtons.size() > 0) ? existingButtons : pageActionsContainer;
            }
            return $(".project-config-panel-header > .operation-menu");
        }

        function showHelpTip($anchor) {
            if (AJS.HelpTip) {
                var helpTip = new AJS.HelpTip({
                    id: 'permission-helper-helptip',
                    title: AJS.I18n.getText('permissionhelper.nav.helptip.title'),
                    body: AJS.I18n.getText('permissionhelper.nav.helptip.body'),
                    anchor: $anchor
                });
                helpTip.show();

                $('#permission-helper-helptip').click(function () {
                    AJS.HelpTip.dismiss();
                });
                $anchor.click(function () {
                    helpTip.dismiss();
                })
            }
        }
    }
});