define('jira/admin-helper/permission-helper/content-loader', [
    'jquery',
    'jira/admin-helper/context',
    'jira/admin-helper/permission-helper/ui'
], function (
    $,
    Context,
    HelperUi
) {
    return {
        loadContent: function loadContent(dialog, callback) {
            var currentIssueKey = createViewContext().issueKey() || '';

            AJS.trigger('analyticsEvent', {
                name: 'adminhelper.permhelper.dialog.open',
                data: {
                    issueKeyPresent: currentIssueKey != '',
                    onEditProjectPermission: $("#edit_project_permissions").length > 0,
                    onNewEditProjectPermission: $(".project-permissions-container .admin-header-actions-plugin-point").length > 0,
                    onViewPermissionsPage: $("#project-config-panel-permissions").length > 0
                }
            });

            dialog.addHeading(AJS.I18n.getText("permissionhelper.dialog.title"));
            dialog.onContentReady(function onContentReady() {
                HelperUi.initUi(dialog.get$popupContent(), createViewContext(), function () {
                    dialog._positionInCenter();
                });
            });

            callback($(JIRA.Templates.Dialogs.PermissionHelper.searchPage({
                currentIssueKey: currentIssueKey,
                permissionGroups: HelperUi.PERMISSIONS
            })));

            function createViewContext() {
                var issueKey = JIRA.Issue.getIssueKey();
                if (!issueKey && JIRA.IssueNavigator) {
                    issueKey = JIRA.IssueNavigator.getSelectedIssueKey();
                }
                return new Context({
                    issueKey: issueKey
                });
            }
        }
    }
});