require([
    'jquery',
    'jira/ajs/dark-features',
    'jira/util/data/meta'
], function (
    $,
    DarkFeatures,
    Meta
) {
    if (Meta.get("is-admin")) {
        $(function () {
            if (isOnEditNotificationsPage()) {
                var $header = getHeaderOnEditNotificationsPage();
                $header.find(".aui-buttons").append($(JIRA.Templates.Nav.NotificationHelper.editNotificationsNavButton()));
                showHelpTip(AJS.$("#notification-helper-button"));
            }
            else if (isOnViewNotificationsPage()) {
                var $opMenu = getOperationMenuOnViewNotificationsPage();
                // operations menu may be hidden
                if ($opMenu.length == 1) {
                    $opMenu.prepend($(JIRA.Templates.Nav.NotificationHelper.viewNotificationsNavButton()));
                    showHelpTip($("#notification-helper-button"));
                }
            }
        });

        function isOnEditNotificationsPage() {
            var $el = $("#notificationSchemeTable");
            return ($el.length >= 1);
        }

        function isOnViewNotificationsPage() {
            var $el = $("#project-config-notifications-table");
            return ($el.length >= 1);
        }

        function getHeaderOnEditNotificationsPage() {
            var $header = $(".aui-page-panel-content > header");
            if ($header.length == 0) {
                $header = $("<header class='aui-page-header'><div class='aui-page-header-inner'><div class='aui-page-header-actions'><div class='aui-buttons'></div></div></div></header>");
                $(".aui-page-panel-content").prepend($header);
            }
            return $header;
        }

        function getOperationMenuOnViewNotificationsPage() {
            if (DarkFeatures.isEnabled('com.atlassian.jira.config.PDL')) {
                var pageActionsContainer = $("#project-config-panel-notifications > .aui-page-header .aui-page-header-actions");
                var existingButtons = pageActionsContainer.find(".aui-buttons");
                return (existingButtons.size() > 0) ? existingButtons : pageActionsContainer;
            }
            return $(".project-config-panel-header > .operation-menu");
        }

        function showHelpTip($anchor) {
            if (AJS.HelpTip) {
                var helpTip = new AJS.HelpTip({
                    id: 'notification-helper-helptip',
                    title: AJS.I18n.getText('notificationhelper.nav.helptip.title'),
                    body: AJS.I18n.getText('notificationhelper.nav.helptip.body'),
                    anchor: $anchor
                });
                helpTip.show();

                $('#notification-helper-helptip').click(function () {
                    helpTip.dismiss();
                });
                $anchor.click(function () {
                    helpTip.dismiss();
                })
            }
        }
    }
});
