define('jira/admin-helper/context', [
    'jquery',
    'jira/lib/class'
], function(
    $,
    Class
) {
    return Class.extend({

        init: function (options) {
            this.options = options || {};
        },

        issueKey: function (issueKey) {
            if (issueKey) {
                this.options.issueKey = issueKey;
            } else {
                return this.options.issueKey;
            }
        },

        params: function (overridingParams) {
            var theOptions = $.extend({}, this.options);
            if (this._exists(overridingParams)) {
                $.extend(theOptions, overridingParams);
            }
            return theOptions;
        },

        asRequestParams: function (overridingParams) {
            var theOptions = this.params(overridingParams);

            var params = "atl_token=" + atl_token();
            if (this._exists(theOptions.username)) {
                params += "&username=" + theOptions.username;
            }
            if (this._exists(theOptions.issueKey)) {
                params += "&issueKey=" + theOptions.issueKey;
            }
            if (this._exists(theOptions.projectKey)) {
                params += "&projectKey=" + theOptions.projectKey;
            }
            if (this._exists(theOptions.projectId)) {
                params += "&projectId=" + theOptions.projectId;
            }
            if (this._exists(theOptions.issueOperation !== undefined)) {
                params += "&issueOperation=" + theOptions.issueOperation;
            }
            if (this._exists(theOptions.issueTypeId)) {
                params += "&issueTypeId=" + theOptions.issueTypeId;
            }
            return params;
        },

        _exists: function (object) {
            return typeof(object) != 'undefined';
        }

    });

});