define('jira/admin-helper/issue-picker', [
    'jquery',
    'jira/ajs/select/single-select',
    'jira/ajs/list/group-descriptor',
    'jira/ajs/list/item-descriptor'
], function (
    $,
    SingleSelect,
    GroupDescriptor,
    ItemDescriptor
) {

    return SingleSelect.extend({

        init: function (options) {

            function formatResponse(response) {
                if (!response.sections) {
                    return [];
                }
                var ret = [];

                $(response.sections).each(function (i, section) {
                    var groupDescriptor = new GroupDescriptor({
                        weight: i,
                        label: section.label
                    });

                    $(section.issues).each(function (i, issue) {
                        groupDescriptor.addItem(new ItemDescriptor({
                            value: issue.key,
                            label: issue.key + " - " + issue.summaryText,
                            html: issue.keyHtml + " - " + issue.summary,
                            icon: contextPath + issue.img
                        }));
                    });

                    ret.push(groupDescriptor);
                });

                return ret;
            }

            $.extend(options, {
                errorMessage: AJS.I18n.getText("permissionhelper.dialog.issue.missing"),
                ajaxOptions: {
                    /* The "project!=null" JQL query forces the search function to actually search the entire space of
                     * issues (as long as they are associated with a project), rather than the default behaviour of only
                     * searching the current user's recently viewed issues history.
                     *
                     * This should be upgraded to rest/api/2/search as a next step.
                     */
                    url: contextPath + "/rest/api/1.0/issues/picker?currentJQL=project!=null",
                    query: true,
                    formatResponse: formatResponse
                }
            });

            this._super(options);
        }
    });
});

