/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permissionhelper;

import com.atlassian.jira.customfieldhelper.rest.PermissionGroupRepresentation;
import com.atlassian.jira.customfieldhelper.rest.PermissionRepresentation;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionsFactory {
    private final I18nResolver i18nResolver;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    @Autowired
    public PermissionsFactory(I18nResolver i18nResolver, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager) {
        this.i18nResolver = i18nResolver;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
    }

    public List<PermissionGroupRepresentation> getGroups() {
        Locale locale = this.authenticationContext.getLocale();
        PermissionGroupRepresentation projectGroup = new PermissionGroupRepresentation(this.i18nResolver.getText(locale, "admin.permission.group.project.permissions"), this.transformPermissions(locale, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.PROJECTS)));
        PermissionGroupRepresentation issueGroup = new PermissionGroupRepresentation(this.i18nResolver.getText(locale, "admin.permission.group.issue.permissions"), this.transformPermissions(locale, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.ISSUES)));
        PermissionGroupRepresentation votersWatchersGroup = new PermissionGroupRepresentation(this.i18nResolver.getText(locale, "admin.permission.group.voters.and.watchers.permissions"), this.transformPermissions(locale, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.VOTERS_AND_WATCHERS)));
        PermissionGroupRepresentation commentsGroup = new PermissionGroupRepresentation(this.i18nResolver.getText(locale, "admin.permission.group.comments.permissions"), this.transformPermissions(locale, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.COMMENTS)));
        PermissionGroupRepresentation attachmentsGroup = new PermissionGroupRepresentation(this.i18nResolver.getText(locale, "admin.permission.group.attachments.permissions"), this.transformPermissions(locale, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.ATTACHMENTS)));
        PermissionGroupRepresentation timeTrackingGroup = new PermissionGroupRepresentation(this.i18nResolver.getText(locale, "admin.permission.group.time.tracking.permissions"), this.transformPermissions(locale, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.TIME_TRACKING)));
        PermissionGroupRepresentation otherGroup = new PermissionGroupRepresentation(this.i18nResolver.getText(locale, "admin.permission.group.time.tracking.other"), this.transformPermissions(locale, this.permissionManager.getProjectPermissions(ProjectPermissionCategory.OTHER)));
        ArrayList groups = Lists.newArrayList();
        groups.add(projectGroup);
        groups.add(issueGroup);
        groups.add(votersWatchersGroup);
        groups.add(commentsGroup);
        groups.add(attachmentsGroup);
        groups.add(timeTrackingGroup);
        groups.add(otherGroup);
        return groups;
    }

    private Iterable<PermissionRepresentation> transformPermissions(Locale locale, Collection<ProjectPermission> permissions) {
        ArrayList projectPermissions = Lists.newArrayList();
        for (ProjectPermission projectPermission : permissions) {
            projectPermissions.add(new PermissionRepresentation(projectPermission.getKey(), this.i18nResolver.getText(locale, projectPermission.getNameI18nKey())));
        }
        return projectPermissions;
    }
}

