/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.I18nHelper;
import javax.annotation.Nullable;

public class UserHelper {
    private static final UserKeyService userKeyService = ComponentAccessor.getUserKeyService();

    public static String getDisplayName(@Nullable ApplicationUser user) {
        if (user == null) {
            I18nHelper i18n = ComponentAccessor.getI18nHelperFactory().getInstance(user);
            return i18n.getText("common.words.anonymous");
        }
        return user.getDisplayName();
    }

    public static String getUsername(@Nullable ApplicationUser user) {
        return user == null ? "" : user.getName();
    }

    public static String getDisplayName(InspectionContext context) {
        return UserHelper.getDisplayName(context.user());
    }

    public static String getUsername(InspectionContext context) {
        return UserHelper.getUsername(context.user());
    }

    public static String getUserKey(InspectionContext context) {
        return UserHelper.getUserKey(context.user());
    }

    public static String getUserKey(ApplicationUser user) {
        return user != null ? user.getKey() : null;
    }

    public static String getKeyForUsername(String username) {
        return userKeyService.getKeyForUsername(username);
    }

    public static String getUsernameForUserKey(String userKey) {
        return userKeyService.getUsernameForKey(userKey);
    }
}

