/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.rest;

import com.atlassian.jira.customfieldhelper.rest.InvalidRequestException;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InvalidRequestExceptionFactory {
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public InvalidRequestExceptionFactory(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public InvalidRequestException failedWithMessage(Response.Status status, String msgKey, Object ... params) {
        return this.failedWithMessage(this.authenticationContext.getI18nHelper(), status, msgKey, params);
    }

    public InvalidRequestException failedWithMessage(I18nHelper helper, Response.Status status, String msgKey, Object ... params) {
        return this.failed(status, helper.getText(msgKey, (Object)params));
    }

    public InvalidRequestException failedWithFieldError(Response.Status status, String fieldName, String message) {
        return this.failed(status, InvalidRequestExceptionFactory.fieldError(fieldName, message));
    }

    public InvalidRequestException failed(Response.Status status, Object entity) {
        return new InvalidRequestException(Response.status((Response.Status)status).entity(entity).cacheControl(InvalidRequestExceptionFactory.dontCache()).build());
    }

    public InvalidRequestException failed(Response response) {
        return new InvalidRequestException(response);
    }

    private static javax.ws.rs.core.CacheControl dontCache() {
        return CacheControl.never();
    }

    private static ErrorCollection fieldError(String fieldName, String message) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addError(fieldName, message);
        return ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errors);
    }

    private static ErrorCollection errorMessage(String message) {
        return ErrorCollection.of((String[])new String[]{message});
    }
}

