/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.rest;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.FieldInspector;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.context.InspectionContextDecorator;
import com.atlassian.jira.customfieldhelper.rest.FieldInfoJson;
import com.atlassian.jira.customfieldhelper.rest.FieldInfoRequestUserValidator;
import com.atlassian.jira.customfieldhelper.rest.FieldInspectionContextFactory;
import com.atlassian.jira.customfieldhelper.rest.InspectorFactory;
import com.atlassian.jira.customfieldhelper.rest.InvalidRequestException;
import com.atlassian.jira.customfieldhelper.rest.StatusProcessor;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="fields")
@Produces(value={"application/json"})
public class FieldInfoResource {
    static final String FIELD_ID_PARAM = "cfId";
    static final String ISSUE_KEY_PARAM = "issueKey";
    static final String PROJECT_KEY_PARAM = "projectKey";
    static final String PROJECT_ID_PARAM = "projectId";
    static final String ISSUE_TYPE_ID_PARAM = "issueTypeId";
    static final String ISSUE_OPERATION_PARAM = "issueOperation";
    private final FieldManager fieldManager;
    private final InspectorFactory inspectorFactory;
    private final FieldInspectionContextFactory inspectionContextFactory;
    private final FieldInfoRequestUserValidator userValidator;

    public FieldInfoResource(FieldManager fieldManager, InspectorFactory inspectorFactory, FieldInspectionContextFactory inspectionContextFactory, FieldInfoRequestUserValidator userValidator) {
        this.fieldManager = fieldManager;
        this.inspectorFactory = inspectorFactory;
        this.inspectionContextFactory = inspectionContextFactory;
        this.userValidator = userValidator;
    }

    @GET
    @Path(value="all")
    public Response getAllCustomFields() {
        try {
            this.userValidator.validateAndGet();
            return Response.ok((Object)Iterables.transform((Iterable)this.fieldManager.getAllSearchableFields(), (Function)new Function<SearchableField, FieldInfoJson.CfBean>(){

                public FieldInfoJson.CfBean apply(SearchableField input) {
                    return new FieldInfoJson.CfBean(input.getId(), input.getName());
                }
            })).cacheControl(FieldInfoResource.dontCache()).build();
        }
        catch (InvalidRequestException invalidRequest) {
            return invalidRequest.response();
        }
    }

    @GET
    @Path(value="{cfId}")
    public Response getInfo(@PathParam(value="cfId") String cfId, @QueryParam(value="issueKey") String issueKey, @QueryParam(value="projectKey") String projectKey, @QueryParam(value="projectId") Long projectId, @QueryParam(value="issueTypeId") String issueTypeId, @QueryParam(value="issueOperation") Long issueOperationId) {
        try {
            FieldInspectionContext realContext = this.inspectionContextFactory.newRequest(this.userValidator.validateAndGet(), cfId).issueKey(issueKey).projectKey(projectKey).projectId(projectId).issueTypeId(issueTypeId).issueOperationId(issueOperationId).getContext();
            Context context = new Context(realContext);
            this.runInspection(context);
            return Response.ok((Object)this.createOkResponse(context)).cacheControl(FieldInfoResource.dontCache()).build();
        }
        catch (InvalidRequestException invalidRequest) {
            return invalidRequest.response();
        }
    }

    private void runInspection(Context context) {
        for (FieldInspector<? extends Field> inspector : this.inspectorFactory.getFieldInspectors()) {
            if (this.applies(inspector, context)) {
                context.addIssues(this.stupidStupidGenerics(inspector).inspect(context.field(), context));
            }
            if (!context.isExcludeAll) continue;
            break;
        }
    }

    private FieldInspector<Field> stupidStupidGenerics(FieldInspector<? extends Field> inspector) {
        return inspector;
    }

    private Object createOkResponse(Context context) {
        return FieldInfoJson.createInfoBean(context);
    }

    private boolean applies(FieldInspector<?> inspector, Context context) {
        return context.isOfType(inspector.supportedType()) && !context.isExcluded(inspector);
    }

    private static javax.ws.rs.core.CacheControl dontCache() {
        return CacheControl.never();
    }

    final class Context
    extends InspectionContextDecorator
    implements FieldInspectionContext {
        final FieldInspectionContext realContext;
        final List<InspectionNote> inspectionNotes;
        boolean isExcludeAll;

        public Context(FieldInspectionContext realContext) {
            super(realContext);
            this.inspectionNotes = Lists.newArrayList();
            this.isExcludeAll = false;
            this.realContext = (FieldInspectionContext)Preconditions.checkNotNull((Object)realContext, (Object)"realContext");
        }

        @Override
        @Nonnull
        public Field field() {
            return this.realContext.field();
        }

        @Override
        public <F extends Field> boolean isOfType(Class<F> expectedType) {
            return this.realContext.isOfType(expectedType);
        }

        @Override
        @Nonnull
        public <F extends Field> F asFieldType(Class<F> expectedFieldType) {
            return this.realContext.asFieldType(expectedFieldType);
        }

        @Override
        public void excludeAll() {
            this.isExcludeAll = true;
            super.excludeAll();
        }

        public Context addIssues(Iterable<InspectionNote> newIssues) {
            this.inspectionNotes.addAll(Lists.newArrayList(newIssues));
            return this;
        }

        public boolean hasIssues() {
            return !this.inspectionNotes.isEmpty();
        }

        public Iterable<InspectionNote> configIssues() {
            return this.inspectionNotes;
        }

        public InspectionNote.Status status() {
            return StatusProcessor.and(this.inspectionNotes);
        }
    }
}

