/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.scheme;

import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeInspector;
import com.atlassian.jira.scheme.SchemeEntity;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;

public final class SchemeTypes {
    private SchemeTypes() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static Iterable<InspectionNote> forEach(Iterable<SchemeEntity> entities, InspectionContext context, String entityType, SchemeInspector inspector) {
        ImmutableList.Builder notes = ImmutableList.builder();
        for (SchemeEntity entity : Iterables.filter(entities, SchemeTypes.isOfType(entityType))) {
            InspectionNote note = inspector.inspect(entity, context);
            if (note == null) continue;
            notes.add((Object)note);
        }
        return notes.build();
    }

    public static Predicate<SchemeEntity> isOfType(final @Nonnull String type) {
        return new Predicate<SchemeEntity>(){

            public boolean apply(SchemeEntity schemeEntity) {
                return type.equals(schemeEntity.getType());
            }
        };
    }
}

