/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.permission;

import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.PermissionInspectionContext;
import com.atlassian.jira.customfieldhelper.api.ProjectPermissionInspector;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionOverride;
import com.atlassian.jira.security.plugin.ProjectPermissionOverrideModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionOverrideSecurityInspector
implements ProjectPermissionInspector {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PermissionOverrideSecurityInspector(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(@Nonnull PermissionInspectionContext context) {
        ArrayList notes = Lists.newArrayList();
        List permissionOverrideModuleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ProjectPermissionOverrideModuleDescriptor.class);
        for (ProjectPermissionOverrideModuleDescriptor moduleDescriptor : permissionOverrideModuleDescriptors) {
            ProjectPermissionOverride projectPermissionOverride = (ProjectPermissionOverride)moduleDescriptor.getModule();
            ProjectPermissionKey projectPermissionKey = new ProjectPermissionKey(context.permission().getKey());
            ProjectPermissionOverride.Reason reason = projectPermissionOverride.getReason(projectPermissionKey, this.getProjectFromContext(context), context.user());
            if (projectPermissionOverride.hasPermission(projectPermissionKey, this.getProjectFromContext(context), context.user()) == ProjectPermissionOverride.Decision.DENY) {
                notes.add(InspectionNote.problem(InspectionMessageBuilder.newSimpleMessage(context, reason.getSummary())).addDetails(InspectionMessageBuilder.forContext(context).templateKey(reason.getDetails()).build()).required(true).build());
                continue;
            }
            notes.add(InspectionNote.ok(InspectionMessageBuilder.newSimpleMessage(context, reason.getSummary())).addDetails(InspectionMessageBuilder.forContext(context).templateKey(reason.getDetails()).build()).required(true).build());
        }
        return notes;
    }

    private Project getProjectFromContext(InspectionContext context) {
        return context.issueExists() ? context.issue().getProjectObject() : context.project();
    }
}

