/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.notification;

import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.NotificationInspectionContext;
import com.atlassian.jira.customfieldhelper.impl.inspector.notification.AbstractNotificationInspector;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.scheme.SchemeEntity;
import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationNoNotificationsInspector
extends AbstractNotificationInspector {
    @Autowired
    public NotificationNoNotificationsInspector(NotificationSchemeManager manager) {
        super(manager);
    }

    @Override
    @Nonnull
    protected Iterable<InspectionNote> inspectEntities(@Nonnull Iterable<SchemeEntity> entities, @Nonnull NotificationInspectionContext context) {
        if (this.notificationSchemeManager.getSchemeFor(context.project()) == null) {
            context.excludeAll();
            return Collections.singletonList(InspectionNote.problem(InspectionMessageBuilder.newSimpleMessage(context, "adminhelper.notification.inspection.nonotificationscheme.summary")).addDetails(InspectionMessageBuilder.forContext(context).templateKey("adminhelper.notification.inspection.nonotificationscheme.details").addLinkParameterFromI18n("adminhelper.notification.inspection.nonotificationscheme.linktext", "adminhelper.notification.inspection.link.addnotificationscheme", context.project().getId().toString()).build()).build());
        }
        if (Iterables.isEmpty(entities)) {
            return Collections.singletonList(InspectionNote.problem(InspectionMessageBuilder.newSimpleMessage(context, "adminhelper.notification.inspection.nonotifications.summary")).addDetails(InspectionMessageBuilder.forContext(context).templateKey("adminhelper.notification.inspection.nonotifications.details").addPlainParameter(context.eventTypeName()).addLinkParameterFromI18n("adminhelper.notification.inspection.nonotifications.linktext", "adminhelper.notification.inspection.link.addnewnotification", this.notificationSchemeManager.getSchemeFor(context.project()).getId().toString(), context.eventType().getId().toString()).build()).build());
        }
        return Collections.emptyList();
    }
}

