/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.TimeTrackingSystemField;
import com.atlassian.jira.issue.fields.WorklogSystemField;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimeTrackingInspector
extends AbstractFieldInspector<Field> {
    private final ApplicationProperties applicationProperties;

    @Autowired
    public TimeTrackingInspector(ApplicationProperties applicationProperties) {
        super(Field.class);
        this.applicationProperties = applicationProperties;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(Field field, FieldInspectionContext context) {
        ImmutableList.Builder answer = ImmutableList.builder();
        if (context.isOfType(WorklogSystemField.class) && context.issueOperation() == IssueOperations.VIEW_ISSUE_OPERATION) {
            context.excludeAll();
            answer.add((Object)InspectionNote.problem().addSummary(this.createWorklogOnViewSummary(context)).addDetails(this.createWorklogOnViewProblemDetails(context)).build());
        }
        if (this.isTimeTrackingField(context)) {
            if (this.timeTrackingEnabled()) {
                answer.add((Object)this.createTimeTrackingOk(context));
            } else {
                if (context.isOfType(TimeTrackingSystemField.class)) {
                    context.exclude("com.atlassian.jira.customfieldhelper.inspection.FIELD_CONFIGURATION");
                }
                answer.add((Object)this.createTimeTrackingProblem(context));
            }
        }
        return answer.build();
    }

    private boolean timeTrackingEnabled() {
        return this.applicationProperties.getOption("jira.option.timetracking");
    }

    private boolean isTimeTrackingField(FieldInspectionContext context) {
        return context.isOfType(TimeTrackingSystemField.class) || context.isOfType(WorklogSystemField.class);
    }

    private InspectionNote createTimeTrackingOk(FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(this.createTimeTrackingSummary(context)).addDetails(this.createTimeTrackingOkDetails(context)).build();
    }

    private InspectionNote createTimeTrackingProblem(FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(this.createTimeTrackingSummary(context)).addDetails(this.createTimeTrackingProblemDetails(context)).build();
    }

    private InspectionMessage createWorklogOnViewSummary(FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.worklogonview.summary");
    }

    private InspectionMessage createWorklogOnViewProblemDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.worklogonview.problem");
    }

    private InspectionMessage createTimeTrackingSummary(FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.timetracking.summary");
    }

    private InspectionMessage createTimeTrackingOkDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.timetracking.ok");
    }

    private InspectionMessage createTimeTrackingProblemDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.timetracking.problem").addNewLine().addLinkParameterFromI18n("whereismycf.inspection.timetracking.problem.linktext.timetracking", "whereismycf.inspection.link.timetracking", new Object[0]).build();
    }
}

