/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.FieldInspector;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import javax.annotation.Nonnull;

public class PermissionInspector
extends AbstractFieldInspector<Field>
implements FieldInspector<Field> {
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18nHelperFactory;
    private final String fieldId;
    private final ProjectPermissionKey projectPermissionKey;
    private String projectPermissionI18nNameKey;

    public PermissionInspector(PermissionManager permissionManager, String fieldId, I18nHelper.BeanFactory i18nHelperFactory, ProjectPermissionKey projectPermissionKey, String projectPermissionI18nNameKey) {
        super(Field.class);
        this.i18nHelperFactory = i18nHelperFactory;
        this.projectPermissionI18nNameKey = projectPermissionI18nNameKey;
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager, (Object)"permissionManager");
        this.fieldId = (String)Preconditions.checkNotNull((Object)fieldId, (Object)"fieldId");
        this.projectPermissionKey = projectPermissionKey;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(Field field, FieldInspectionContext context) {
        if (field.getId().equals(this.fieldId)) {
            return this.checkPermissions(field, context);
        }
        return Collections.emptyList();
    }

    private Iterable<InspectionNote> checkPermissions(Field field, FieldInspectionContext context) {
        if (context.issueOperation() != IssueOperations.VIEW_ISSUE_OPERATION) {
            if (this.hasPermission(context)) {
                return ImmutableList.of((Object)this.crateOk(field, context));
            }
            return ImmutableList.of((Object)this.crateProblem(field, context));
        }
        return Collections.emptyList();
    }

    private boolean hasPermission(FieldInspectionContext context) {
        return context.issue().isCreated() ? this.permissionManager.hasPermission(this.projectPermissionKey, context.issue(), context.user()) : this.permissionManager.hasPermission(this.projectPermissionKey, context.project(), context.user());
    }

    private InspectionNote crateOk(Field field, FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(this.createSummary(context)).addDetails(this.createOkDetails(field, context)).build();
    }

    private InspectionNote crateProblem(Field field, FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(this.createSummary(context)).addDetails(this.createProblemDetails(field, context)).build();
    }

    private InspectionMessage createSummary(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.permission.summary").addPlainParameter(this.i18nHelperFactory.getInstance(context.user()).getText(this.projectPermissionI18nNameKey)).build();
    }

    private InspectionMessage createOkDetails(Field field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.permission.ok").addPlainParameter(this.i18nHelperFactory.getInstance(context.user()).getText(this.projectPermissionI18nNameKey)).addPlainParameter(field.getName()).build();
    }

    private InspectionMessage createProblemDetails(Field field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.permission.problem").addPlainParameter(field.getName()).addPlainParameter(this.i18nHelperFactory.getInstance(context.user()).getText(this.projectPermissionI18nNameKey)).addNewLine().addLinkParameterFromI18n("whereismycf.inspection.permission.problem.linktext.permissions", "whereismycf.inspection.link.projectpermissions", context.project().getKey()).addLinkParameterFromI18n("whereismycf.inspection.permission.problem.linktext.people", "whereismycf.inspection.link.projectpeople", context.project().getKey()).addPlainParameter(context.project().getName()).build();
    }
}

