/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.issue.fields.Field;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;

public class InternalSystemFieldInspector<F extends Field>
extends AbstractFieldInspector<F> {
    public static <G extends Field> InternalSystemFieldInspector<G> forFieldType(Class<G> fieldType) {
        return new InternalSystemFieldInspector<G>(fieldType);
    }

    public InternalSystemFieldInspector(Class<F> supportedType) {
        super(supportedType);
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(F field, FieldInspectionContext context) {
        context.excludeAll();
        return ImmutableList.of((Object)this.createNotPresentNote(field, context));
    }

    private InspectionNote createNotPresentNote(F field, FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(this.createSummary(field, context)).addDetails(this.createNotPresentDetails(field, context)).build();
    }

    private InspectionMessage createSummary(F field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.internal.summary").addPlainParameter(field.getName()).build();
    }

    private InspectionMessage createNotPresentDetails(F field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.internal.problem").addPlainParameter(field.getName()).build();
    }
}

