/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.FieldInspector;
import com.atlassian.jira.customfieldhelper.api.IdentifiableInspector;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;

public class FieldConfigurationInspector
extends AbstractFieldInspector<OrderableField>
implements FieldInspector<OrderableField>,
IdentifiableInspector {
    public static final String INSPECTION_ID = "com.atlassian.jira.customfieldhelper.inspection.FIELD_CONFIGURATION";
    private final FieldLayoutManager fieldLayoutManager;

    public FieldConfigurationInspector(FieldLayoutManager fieldLayoutManager) {
        super(OrderableField.class);
        this.fieldLayoutManager = fieldLayoutManager;
    }

    @Override
    @Nonnull
    public String inspectionId() {
        return INSPECTION_ID;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(OrderableField field, FieldInspectionContext context) {
        FieldLayout layout = this.fieldLayoutManager.getFieldLayout(context.project(), context.issueType().getId());
        FieldLayoutItem item = layout.getFieldLayoutItem(field);
        if (item == null) {
            return ImmutableList.of((Object)this.createNoItemProblem(field, context, layout));
        }
        if (item.isHidden()) {
            return ImmutableList.of((Object)this.createHiddenItemProblem(field, context, layout));
        }
        return ImmutableList.of((Object)this.createOk(field, context, layout));
    }

    private InspectionNote createOk(OrderableField field, FieldInspectionContext context, FieldLayout layout) {
        return InspectionNote.ok().addSummary(this.createSummary(context)).addDetails(this.createOkDetails(field, context, layout)).build();
    }

    private InspectionMessage createOkDetails(OrderableField field, FieldInspectionContext context, FieldLayout layout) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.layoutitem.ok").addPlainParameter(field.getName()).addPlainParameter(layout.getName()).build();
    }

    private InspectionNote createNoItemProblem(OrderableField field, FieldInspectionContext context, FieldLayout layout) {
        return InspectionNote.problem().addSummary(this.createSummary(context)).addDetails(this.createNoItemDetails(field, context, layout)).build();
    }

    private InspectionNote createHiddenItemProblem(OrderableField field, FieldInspectionContext context, FieldLayout layout) {
        return InspectionNote.problem().addSummary(this.createSummary(context)).addDetails(this.createHiddenItemDetails(field, context, layout)).build();
    }

    private InspectionMessage createNoItemDetails(OrderableField field, FieldInspectionContext context, FieldLayout layout) {
        FieldConfigurationScheme scheme = this.fieldLayoutManager.getFieldConfigurationScheme(context.project());
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.layoutitem.problem.nolayoutitem").addPlainParameter(field.getName()).addPlainParameter(layout.getName()).addNewLine().addLinkParameterFromI18n("whereismycf.inspection.problem.nolayoutitem.linktext.fieldconfigurations", "whereismycf.inspection.link.viewfieldconfigurations", new Object[0]).addPlainParameter(context.issueTypeName()).newI18nLinkParameter().textKey("whereismycf.inspection.problem.nolayoutitem.linktext.fieldconfigurationscheme").textParams(scheme.getName()).pathKey("whereismycf.inspection.link.fieldconfigurationscheme").urlParams(scheme.getId()).add().build();
    }

    private InspectionMessage createHiddenItemDetails(OrderableField field, FieldInspectionContext context, FieldLayout layout) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.layoutitem.problem.hiddenlayoutitem").addPlainParameter(field.getName()).newI18nLinkParameter().textKey("whereismycf.inspection.layoutitem.problem.hiddenlayoutitem.linktext.configurefieldconfiguration1").textParams(layout.getName()).pathKey("whereismycf.inspection.link.configurefieldconfiguration").urlParams(layout.getId()).add().addNewLine().addLinkParameterFromI18n("whereismycf.inspection.layoutitem.problem.hiddenlayoutitem.linktext.configurefieldconfiguration2", "whereismycf.inspection.link.configurefieldconfiguration", layout.getId()).build();
    }

    private InspectionMessage createSummary(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.layoutitem.summary").build();
    }
}

