/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.engine;

import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.Inspector;
import com.google.common.collect.ImmutableList;

public abstract class AbstractInspectorEngine<I extends Inspector<C>, C extends InspectionContext> {
    private final Iterable<? extends I> inspectors;

    protected AbstractInspectorEngine(Iterable<? extends I> inspectors) {
        this.inspectors = inspectors;
    }

    public Iterable<InspectionNote> run(C context) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Inspector inspector : this.inspectors) {
            if (!context.isExcluded(inspector) && this.applies(inspector, context)) {
                result.addAll(inspector.inspect(context));
            }
            if (!context.isExcludeAll()) continue;
            break;
        }
        return result.build();
    }

    protected boolean applies(I inspector, C context) {
        return true;
    }
}

