/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.adminhelper.web;

import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;

public class NotificationEventsDataProvider
implements WebResourceDataProvider {
    private static final Long DEFAULT_EVENT_ID = EventType.ISSUE_CREATED_ID;
    private final EventTypeManager eventTypeManager;
    private final I18nResolver i18nResolver;
    private final JiraAuthenticationContext authenticationContext;

    public NotificationEventsDataProvider(EventTypeManager eventTypeManager, I18nResolver i18nResolver, JiraAuthenticationContext authenticationContext) {
        this.eventTypeManager = eventTypeManager;
        this.authenticationContext = authenticationContext;
        this.i18nResolver = i18nResolver;
    }

    public Jsonable get() {
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                try {
                    new JSONArray((Collection)Lists.newArrayList((Iterable)NotificationEventsDataProvider.this.getAllEvents())).write(writer);
                }
                catch (JSONException e) {
                    throw new Jsonable.JsonMappingException((Throwable)e);
                }
            }
        };
    }

    private Iterable<JSONObject> getAllEvents() {
        Collection eventTypes = this.eventTypeManager.getEventTypes();
        return Iterables.transform((Iterable)eventTypes, (Function)new Function<EventType, JSONObject>(){

            public JSONObject apply(EventType eventType) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)"id", (Object)eventType.getId());
                builder.put((Object)"name", (Object)NotificationEventsDataProvider.this.i18nResolver.getText(NotificationEventsDataProvider.this.authenticationContext.getLocale(), eventType.getNameKey()));
                if (DEFAULT_EVENT_ID.equals(eventType.getId())) {
                    builder.put((Object)"isDefault", (Object)true);
                }
                return new JSONObject((Map)builder.build());
            }
        });
    }
}

