/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.jira;

import com.atlassian.activeobjects.jira.JiraDatabaseTypeExtractor;
import com.atlassian.activeobjects.jira.NonClosingDelegatingConnection;
import com.atlassian.activeobjects.spi.AbstractTenantAwareDataSourceProvider;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.tenancy.api.Tenant;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;

public final class JiraTenantAwareDataSourceProvider
extends AbstractTenantAwareDataSourceProvider {
    private static final Map<org.ofbiz.core.entity.jdbc.dbtype.DatabaseType, DatabaseType> DB_TYPE_TO_DB_TYPE = ImmutableMap.builder().put((Object)DatabaseTypeFactory.H2, (Object)DatabaseType.H2).put((Object)DatabaseTypeFactory.HSQL, (Object)DatabaseType.HSQL).put((Object)DatabaseTypeFactory.MSSQL, (Object)DatabaseType.MS_SQL).put((Object)DatabaseTypeFactory.MYSQL, (Object)DatabaseType.MYSQL).put((Object)DatabaseTypeFactory.ORACLE_10G, (Object)DatabaseType.ORACLE).put((Object)DatabaseTypeFactory.POSTGRES, (Object)DatabaseType.POSTGRESQL).put((Object)DatabaseTypeFactory.POSTGRES_7_2, (Object)DatabaseType.POSTGRESQL).put((Object)DatabaseTypeFactory.POSTGRES_7_3, (Object)DatabaseType.POSTGRESQL).build();
    private final OfBizConnectionFactory connectionFactory;
    private final JiraDatabaseTypeExtractor databaseTypeExtractor;
    private final DataSource ds;

    public JiraTenantAwareDataSourceProvider(OfBizConnectionFactory connectionFactory, JiraDatabaseTypeExtractor databaseTypeExtractor) {
        this.connectionFactory = (OfBizConnectionFactory)Preconditions.checkNotNull((Object)connectionFactory);
        this.databaseTypeExtractor = (JiraDatabaseTypeExtractor)Preconditions.checkNotNull((Object)databaseTypeExtractor);
        this.ds = new OfBizDataSource(connectionFactory);
    }

    @Nonnull
    public DataSource getDataSource(@Nonnull Tenant tenant) {
        return this.ds;
    }

    @Nonnull
    public DatabaseType getDatabaseType(@Nonnull Tenant tenant) {
        return (DatabaseType)Suppliers.memoize((Supplier)new Supplier<DatabaseType>(){

            public DatabaseType get() {
                DatabaseType databaseType;
                Connection connection = null;
                try {
                    connection = JiraTenantAwareDataSourceProvider.this.ds.getConnection();
                    DatabaseType type = (DatabaseType)DB_TYPE_TO_DB_TYPE.get(JiraTenantAwareDataSourceProvider.this.databaseTypeExtractor.getDatabaseType(connection));
                    databaseType = type != null ? type : DatabaseType.UNKNOWN;
                }
                catch (SQLException e) {
                    try {
                        throw new IllegalStateException("Could not get database type", e);
                    }
                    catch (Throwable throwable) {
                        JiraTenantAwareDataSourceProvider.closeQuietly(connection);
                        throw throwable;
                    }
                }
                JiraTenantAwareDataSourceProvider.closeQuietly(connection);
                return databaseType;
            }
        }).get();
    }

    public String getSchema(@Nonnull Tenant tenant) {
        return this.connectionFactory.getDatasourceInfo().getSchemaName();
    }

    private static void closeQuietly(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                throw new IllegalStateException("There was an exception closing a database connection", e);
            }
        }
    }

    private static abstract class AbstractDataSource
    implements DataSource {
        private AbstractDataSource() {
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public void setLoginTimeout(int timeout) throws SQLException {
            throw new UnsupportedOperationException("setLoginTimeout");
        }

        @Override
        public PrintWriter getLogWriter() {
            throw new UnsupportedOperationException("getLogWriter");
        }

        @Override
        public void setLogWriter(PrintWriter pw) throws SQLException {
            throw new UnsupportedOperationException("setLogWriter");
        }

        @Override
        public <T> T unwrap(Class<T> tClass) throws SQLException {
            throw new UnsupportedOperationException("unwrap");
        }

        @Override
        public boolean isWrapperFor(Class<?> aClass) throws SQLException {
            throw new UnsupportedOperationException("isWrapperFor");
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException();
        }
    }

    private static class OfBizDataSource
    extends AbstractDataSource {
        private final OfBizConnectionFactory connectionFactory;

        public OfBizDataSource(OfBizConnectionFactory connectionFactory) {
            this.connectionFactory = (OfBizConnectionFactory)Preconditions.checkNotNull((Object)connectionFactory);
        }

        @Override
        public Connection getConnection() throws SQLException {
            Connection connection = CoreTransactionUtil.getConnection();
            if (connection == null) {
                return this.connectionFactory.getConnection();
            }
            return new NonClosingDelegatingConnection(connection);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            throw new IllegalStateException("Not allowed to get a connection for non default username/password");
        }
    }
}

