require(['jquery', 'wrm/context-path'], function ($, wrmContextPath) {

    function getStatusCode(response) {
        var statusCode;
        if (response.presence.is_online) {
            if (response.presence.show === "xa" || response.presence.show === "away") {
                statusCode = "away";
            } else if (response.presence.show === "dnd") {
                statusCode = "dnd";
            } else {
                statusCode = "available";
            }
        } else {
            statusCode = "offline";
        }
        return statusCode;
    }

    function onFail(jxr) {
        if (jxr.status === 404) {
            try {
                var result = JSON.parse(jxr.responseText);
                if (result.userId) {
                    sendAnalyticEvent("hipchat.presence.user.unknown", result.userId);
                }
            } catch (e) {
                // ignore
            }
        }
    }

    function sendAnalyticEvent(event, userId) {
        AJS.trigger('analyticsEvent', {
            name: event,
            data: {
                userId: userId
            }
        });
    }

    function handleAjaxComplete(e, x) {
        if (x.responseText && /user\-hover\-info/.test(x.responseText)) {
            $('.user-hover-info').each(function () {
                var $vcard = $(this);
                var username = $("#avatar-image-link", $vcard).attr('title');
                if (username && !$vcard.hasClass('hc-status-applied')) {

                    $.getJSON(wrmContextPath() + '/rest/hipchat/integration/latest/users/' + encodeURI(username), function (response) {

                        $vcard.addClass('hc-status-applied');
                        var statusCode = getStatusCode(response);

                        $vcard.find('.user-hover-avatar').append('<a class="hc-status ' + statusCode + '" title="' +
                            statusCode + ' on HipChat"><span>' +
                            statusCode + '</span></a>');

                        if (response.hipChatUserId && response.apiUrl) {
                            var tooltip = AJS.I18n.getText("jira.plugins.hipchat.open.chat");
                            $vcard.find('h4').append('<a href="#" class="hc-direct-chat hipchat-user-link-url"' +
                                ' data-api-url="' + response.apiUrl + '" data-user-id="' + response.hipChatUserId +
                                '" title="' + tooltip +
                                '"><span class="aui-icon aui-icon-small aui-iconfont-hipchat">Chat</span></a>');
                        }

                        sendAnalyticEvent("hipchat.presence.user.found", response.userId);

                    }).fail(function (jxr) {
                        onFail(jxr);
                    });
                }
            });

        }
    }

    $(function() {
        $('body').bind('ajaxComplete', handleAjaxComplete);
    });
});
