define("hipchat/feature/roommapping/mapping-collection",
[
    "backbone",
    "hipchat/feature/roommapping/mapping"
], function (
    Backbone,
    Mapping
) {
    var Mappings = Backbone.Collection.extend({
        model: Mapping,

        comparator: function(mapping1, mapping2) {
            var mapping1ProjectName = mapping1.get("projectName").toString().toLocaleLowerCase();
            var mapping2ProjectName = mapping2.get("projectName").toString().toLocaleLowerCase();
            var projectNameComparison = mapping1ProjectName.localeCompare(mapping2ProjectName);
            if (projectNameComparison !== 0) {
                return projectNameComparison;
            }

            var mapping1RoomName = mapping1.get("roomName").toString().toLocaleLowerCase();
            var mapping2RoomName = mapping2.get("roomName").toString().toLocaleLowerCase();
            var roomNameComparison = mapping1RoomName.localeCompare(mapping2RoomName);
            return roomNameComparison;
        }
    });

    return Mappings;
});