define("hipchat/feature/issuepanel/invitecontributors",
[
    "jquery",
    "backbone"
], function (
    $,
    Backbone
) {

    var InviteContributors = Backbone.Model.extend({

        defaults : {
            hipChatUsersMap: {},
            appUsersMap: {}
        },

        initialize: function() {
            this.attributes.hipChatUsersMap = {};
            this.attributes.appUsersMap = {};
        },

        url: function () {
            return AJS.contextPath() + '/rest/hipchat/integrations/1.0/invite/issue/' + this.attributes.issueKey;
        },

        destroy: function () {
            // By default, Backbone doesn't send anything on destroy
            //this.id = this.get("configurationGroupId") + "-" + this.get("name");
            var options = {
                data: JSON.stringify(this.toJSON()),
                contentType: 'application/json'
            };

            return Backbone.Model.prototype.destroy.call(this, options);
        }
    });

    return InviteContributors;

});