(function ($,
    _,
    inviteUserPicker) {
    function init() {
        var form = $('#hipchat-invite-form');
        var userField = form.find('#hipchat-invite-user');

        function makeParams(val) {
            return {
                maxResults: 10,
                query: val,
                showAvatar: true
            };
        }

        function processResults(data, page) {
            var results = _.reduce(data.users, function (m, item) {
                m.push({
                    id: item.name,
                    text: item.displayName,
                    restObj: item
                });
                return m;
            }, []);
            return {
                results: results
            };
        }

        function processChoice(props) {
            var deferred = $.Deferred();

            getExtraData(props.restObj.name).always(function(extraData) {

                var choice = {
                    username: props.restObj.name,
                    fullname: props.restObj.displayName,
                    avatarUrl: props.restObj.avatarUrl
                };

                $.extend(choice, extraData);

                deferred.resolve(choice);
            });

            return deferred.promise();
        }

        function getExtraData(username) {
            var url = AJS.contextPath() + "/rest/api/2/user";
            var deferred = $.Deferred();

            $.ajax(url, {
                type: "GET",
                dataType: 'json',
                contentType: 'application/json',
                data: {
                    username: username
                }
            }).always(function(data) {
                var extraData = {};
                if(data) {
                    if(data.emailAddress)
                        extraData.email = data.emailAddress;
                    if(data.avatarUrls && data.avatarUrls["48x48"])
                        extraData.avatarUrl = data.avatarUrls["48x48"];
                }
                deferred.resolve(extraData);
            });

            return deferred.promise();
        }


        inviteUserPicker(userField, form, {
            url: AJS.contextPath() + "/rest/api/2/user/picker",
            params: makeParams,
            results: processResults,
            choice: processChoice
        });
    }

    $(function () {
        init();
    });

})(
    require('jquery'),
    require('underscore'),
    require('hipchat/invite/user-picker')
);
