(function ($) {
    function send_analytics_event(eventName) {
        var web_panel = AJS.$("#hipchat-glance-webpanel");
        var room_id = web_panel.attr('data-room-id');
        var group_id = web_panel.attr('data-group-id');
        var hipchat_user_id = web_panel.attr('data-hipchat-user-id');
        AJS.trigger('analyticsEvent', {
            name: eventName,
            data: {
                roomId: room_id,
                groupId: group_id,
                userId: hipchat_user_id
            }
        });
    }

    function init() {
        $(document).on('aui-dropdown2-show', '#glance-settings', function () {
            $(this).css({
                top: "inherit",
                left: "inherit",
                bottom: "30px",
                right: 0,
                position: "fixed"
            });
        });
    }

    function handleLogoffRequest(event) {
      var web_panel = AJS.$("#hipchat-glance-webpanel");
      var jira_user_key = web_panel.attr('data-jira-user-key');
      var disconnect_url = web_panel.attr('data-disconnect-url');

      AJS.$.ajax({
          url: AJS.contextPath() + '/rest/hipchat/integrations/1.0/hipconnect/disconnect/'
          + jira_user_key,
          type: 'DELETE',
          contentType: 'application/json',
          dataType: 'json',
          cache: false
        }).done(function() {
          send_analytics_event('jira.hipchat.integration.glance.user.disconnected');
          window.open(disconnect_url, "_self");
        });
    }

    function registerListener() {
      HipChat.register({
        "glance-update": function(data) {
          HipChat.auth.withToken(function (err, token) {
            window.location.href = AJS.contextPath() + '/secure/HipChatGlanceWebPanel.jspa?signed_request=' + token;
          });
        }
      });
    }

    function addNewJwtToken() {
      var jqueryElement = $("#authenticate-user");
      var hrefString = jqueryElement.attr("href");
      if(hrefString) {
        var indexOfSignedRequest = hrefString.indexOf("signed_request");
        if (indexOfSignedRequest === -1) {
          HipChat.auth.withToken(function (err, token) {
            jqueryElement.attr("href", jqueryElement.attr("href") + "&signed_request=" + token);
          });
        } else {
          HipChat.auth.withToken(function (err, token) {
            jqueryElement.attr("href", jqueryElement.attr("href").slice(0, indexOfSignedRequest) + "signed_request=" + token);
          });
        }
      }
    }

  function addClickHandlers() {
    $("#jira-disconnect-link").click(handleLogoffRequest);
    $("#hc-see-in-jira").click(function () {
      send_analytics_event("jira.hipchat.integration.glance.open.jql.in.jira")
    });
    $("#hc-configure").click(function () {
      send_analytics_event("jira.hipchat.integration.glance.configure.from.sidebar")
    });
    $(".see-in-jira-link").click(function () {
      send_analytics_event("jira.hipchat.integration.glance.issue.clicked")
    });
  }

  $(function () {
    init();
        setInterval(function () { send_analytics_event('jira.hipchat.integration.glance.view.is.open'); }, 5 * 60 * 1000);
        registerListener();

        addClickHandlers();

        addNewJwtToken();
        setInterval(addNewJwtToken, 5 * 1000);
    });
})(
        require("jquery")
);
