/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.WebhookNotFoundException;
import com.atlassian.crowd.manager.webhook.InvalidWebhookEndpointException;
import com.atlassian.crowd.model.webhook.Webhook;
import com.atlassian.crowd.plugin.rest.entity.WebhookEntity;
import com.atlassian.crowd.plugin.rest.service.controller.WebhooksController;
import com.atlassian.crowd.plugin.rest.service.resource.AbstractResource;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

@Path(value="webhook")
@AnonymousAllowed
public class WebhooksResource
extends AbstractResource {
    private final WebhooksController webhooksController;

    public WebhooksResource(WebhooksController webhooksController) {
        this.webhooksController = webhooksController;
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response registerWebhook(WebhookEntity webhookEntity) throws InvalidWebhookEndpointException {
        Preconditions.checkArgument((webhookEntity != null ? 1 : 0) != 0, (Object)"missing Webhook entity");
        Preconditions.checkArgument((webhookEntity.getEndpointUrl() != null ? 1 : 0) != 0, (Object)"missing Webhook endpoint URL");
        String applicationName = this.getApplicationName();
        Webhook webhook = this.webhooksController.registerWebhook(applicationName, webhookEntity.getEndpointUrl(), webhookEntity.getToken());
        URI webhookResourceUri = UriBuilder.fromPath((String)Long.toString(webhook.getId())).build(new Object[0]);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new WebhookEntity(webhook)).location(webhookResourceUri).build();
    }

    @POST
    @Consumes(value={"text/plain"})
    @XsrfProtectionExcluded
    public Response registerWebhookWithSimpleBody(String endpointUrl) throws InvalidWebhookEndpointException {
        Preconditions.checkArgument((endpointUrl != null ? 1 : 0) != 0, (Object)"missing Webhook endpoint URL");
        String applicationName = this.getApplicationName();
        Webhook webhook = this.webhooksController.registerWebhook(applicationName, endpointUrl, null);
        URI webhookResourceUri = UriBuilder.fromPath((String)Long.toString(webhook.getId())).build(new Object[0]);
        return Response.created((URI)webhookResourceUri).build();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{webhookId}")
    public Response getWebhook(@PathParam(value="webhookId") Long id) throws WebhookNotFoundException, ApplicationPermissionException {
        Preconditions.checkNotNull((Object)id, (Object)"Webhook id");
        String applicationName = this.getApplicationName();
        Webhook webhook = this.webhooksController.findWebhookById(applicationName, id);
        return Response.ok((Object)new WebhookEntity(webhook)).build();
    }

    @DELETE
    @Path(value="{webhookId}")
    public Response unregisterWebhook(@PathParam(value="webhookId") Long id) throws WebhookNotFoundException, ApplicationPermissionException {
        Preconditions.checkNotNull((Object)id, (Object)"Webhook id");
        String applicationName = this.getApplicationName();
        this.webhooksController.unregisterWebhook(applicationName, id);
        return Response.noContent().build();
    }
}

