/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.plugin.rest.entity.CrowdConnectionTestEntity;
import com.atlassian.crowd.plugin.rest.entity.LdapConnectionTestEntity;
import com.atlassian.crowd.plugin.rest.entity.LdapSearchTestEntity;
import com.atlassian.crowd.plugin.rest.service.resource.directory.DirectoryTestFailedException;
import com.atlassian.crowd.plugin.rest.util.ApplicationEntityTranslator;
import com.atlassian.crowd.search.ldap.test.LDAPConfigurationTester;
import com.atlassian.crowd.search.ldap.test.PageSizeValidator;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class DirectoryController {
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private final DirectoryManager directoryManager;
    private final LDAPConfigurationTester ldapConfigurationTester;

    public DirectoryController(DirectoryInstanceLoader directoryInstanceLoader, DirectoryManager directoryManager, LDAPConfigurationTester ldapConfigurationTester) {
        this.directoryInstanceLoader = directoryInstanceLoader;
        this.directoryManager = directoryManager;
        this.ldapConfigurationTester = ldapConfigurationTester;
    }

    public void testLdapConnection(LdapConnectionTestEntity connectionTestData) throws OperationFailedException, DirectoryTestFailedException {
        DirectoryImpl directory = ApplicationEntityTranslator.buildDirectoryConfiguration(connectionTestData);
        RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getRawDirectory(directory.getId(), directory.getImplementationClass(), directory.getAttributes());
        this.testConnectionToDirectory(remoteDirectory);
    }

    public void testLdapConnection(LdapConnectionTestEntity connectionTestData, Long id) throws DirectoryNotFoundException, OperationFailedException, DirectoryTestFailedException {
        DirectoryImpl directory = new DirectoryImpl(this.directoryManager.findDirectoryById(id.longValue()));
        String password = !StringUtils.isBlank(connectionTestData.getUserDN()) && connectionTestData.getLdapPassword() == null ? directory.getValue("ldap.password") : connectionTestData.getLdapPassword();
        ApplicationEntityTranslator.populateDirectoryAttributesForConnectionTest((Map<String, String>)directory.getAttributes(), connectionTestData, password);
        RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getRawDirectory(directory.getId(), directory.getImplementationClass(), directory.getAttributes());
        this.testConnectionToDirectory(remoteDirectory);
    }

    public void testCrowdConnection(CrowdConnectionTestEntity connectionTestData) throws OperationFailedException, DirectoryTestFailedException {
        DirectoryImpl directory = ApplicationEntityTranslator.buildDirectoryConfiguration(connectionTestData);
        RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getRawDirectory(directory.getId(), directory.getImplementationClass(), directory.getAttributes());
        this.testConnectionToDirectory(remoteDirectory);
    }

    public void testCrowdConnection(CrowdConnectionTestEntity connectionTestData, Long id) throws DirectoryNotFoundException, OperationFailedException, DirectoryTestFailedException {
        DirectoryImpl directory = new DirectoryImpl(this.directoryManager.findDirectoryById(id.longValue()));
        String password = connectionTestData.getApplicationPassword() == null ? directory.getValue("application.password") : connectionTestData.getApplicationPassword();
        ApplicationEntityTranslator.populateDirectoryAttributesForConnectionTest((Map<String, String>)directory.getAttributes(), connectionTestData, password);
        RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getRawDirectory(directory.getId(), directory.getImplementationClass(), directory.getAttributes());
        this.testConnectionToDirectory(remoteDirectory);
    }

    public void testLdapSearch(LdapSearchTestEntity configuration) throws OperationFailedException, DirectoryTestFailedException {
        this.checkConfiguration(configuration, true);
        LDAPConfigurationTester.Strategy strategy = LDAPConfigurationTester.Strategy.valueOf((String)configuration.getStrategy());
        Map<String, String> directoryAttributes = ApplicationEntityTranslator.populateDirectoryAttributesForSearchTest(configuration, new HashMap<String, String>());
        RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getRawDirectory(null, configuration.getConnector(), directoryAttributes);
        if (!this.ldapConfigurationTester.canFindLdapObjects(remoteDirectory, strategy)) {
            throw new DirectoryTestFailedException();
        }
    }

    public void testLdapSearch(LdapSearchTestEntity configuration, Long id) throws OperationFailedException, DirectoryNotFoundException, DirectoryTestFailedException {
        this.checkConfiguration(configuration, false);
        LDAPConfigurationTester.Strategy strategy = LDAPConfigurationTester.Strategy.valueOf((String)configuration.getStrategy());
        Directory directory = this.directoryManager.findDirectoryById(id.longValue());
        Map<String, String> directoryAttributes = ApplicationEntityTranslator.populateDirectoryAttributesForSearchTest(configuration, directory);
        RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getRawDirectory(id, directory.getImplementationClass(), directoryAttributes);
        if (!this.ldapConfigurationTester.canFindLdapObjects(remoteDirectory, strategy)) {
            throw new DirectoryTestFailedException();
        }
    }

    private void checkConfiguration(LdapSearchTestEntity configuration, boolean isCreate) {
        if (isCreate) {
            PageSizeValidator.checkPageSize((Boolean)configuration.getPagedResults(), (Integer)configuration.getPagedResultsSize());
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(configuration.getConnector()), (Object)"Connector type is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(configuration.getBaseDN()), (Object)"Base DN is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(configuration.getURL()), (Object)"LDAP URL is required");
        }
        Preconditions.checkArgument((StringUtils.isNotEmpty(configuration.getStrategy()) && Stream.of(LDAPConfigurationTester.Strategy.values()).anyMatch(val -> val.name().equals(configuration.getStrategy())) ? 1 : 0) != 0, (Object)"Search strategy is required");
        LDAPConfigurationTester.Strategy strategy = LDAPConfigurationTester.Strategy.valueOf((String)configuration.getStrategy());
        if (strategy == LDAPConfigurationTester.Strategy.USER) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(configuration.getUserObjectFilter()), (Object)"User object filter is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(configuration.getUserNameAttr()), (Object)"User name attribute is required");
        } else if (strategy == LDAPConfigurationTester.Strategy.GROUP) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(configuration.getGroupObjectFilter()), (Object)"Group object filter is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(configuration.getGroupNameAttr()), (Object)"Group name attribute is required");
        }
    }

    private void testConnectionToDirectory(RemoteDirectory remoteDirectory) throws DirectoryTestFailedException {
        try {
            remoteDirectory.testConnection();
        }
        catch (OperationFailedException e) {
            throw new DirectoryTestFailedException(e);
        }
    }
}

