;(function() {
var util_window, is_supported, event_stream, api_addReporter, api_delegateTo, api_end, util_document, util_promise, util_table, util_element_hound, api_start_is_ready_supported, util_request_immediate_paint, api_find, util_is_dom_content_loaded_done, api_start, api_subscribe, index;
util_window = function () {
  return window;
}();
is_supported = function (window) {
  /**
   * Feature detection for whether mandatory browser features are supported.
   */
  // required for .start() and .end() timing
  // http://caniuse.com/#search=performance.now
  return !!(window.performance && window.performance.now);
}(util_window);
event_stream = [];
api_addReporter = function (eventStream) {
  /**
   * Add a custom reporter to contribute to transition reports.
   *
   * @param {Reporter} reporter
   * @example
   *     api.addReporter(function dateReporter(transition) {
   *         return {
   *             date: Date.now()
   *         };
   *     });
   */
  return function addReporter(reporter) {
    // "addReporter" API has highest priority, so we use .unshift() rather than .push()
    eventStream.unshift({ addReporter: reporter });
  };
}(event_stream);
api_delegateTo = function (eventStream) {
  /**
   * Yield control to another object, giving it all events captured thus far, and all events in the future.
   * @param {function} subscriber
   */
  return function delegateTo(subscriber) {
    while (eventStream.length) {
      subscriber(eventStream.splice(0, 1)[0]);
    }
    eventStream.unshift = subscriber;
    eventStream.push = subscriber;
  };
}(event_stream);
api_end = function (eventStream, window) {
  /**
   * Finish timing and report the results.
   *
   * @param {String} options.key A key that identifies the page that has now finished loading. It must match the
   *     key provided to `start`.
   * @returns {undefined}
   * @example
   *     api.end({key: "jira.issue.view"});
   */
  return function end(options) {
    eventStream.push({
      end: {
        key: options.key,
        timestamp: window.performance.now()
      }
    });
  };
}(event_stream, util_window);
util_document = function (window) {
  return window.document;
}(util_window);
util_promise = function (window) {
  // Exposing `window.Promise` as a module facilitates more aggressive minification.
  return window.Promise;
}(util_window);
util_table = function () {
  /**
   * A multi-dimensional map that supports multiple values per key.
   * @constructor
   */
  function Table() {
    this._ = {};
  }
  /**
   * Recursive iteration over all keys and values. Function argument explanation:
   * {function} args[0] callback Called with arguments: values, key, higherKey, moreHigherKey,...
   * {Object} args[1] items to iterate
   * {string} args[2..n] keys from bottom to top
   *
   * @param {Array} args
   * @returns {undefined}
   */
  var _forEachRecursive = function (args) {
    var callback = args[0];
    var items = args[1];
    // at 1st level it's -> this;
    if (items instanceof Table) {
      if (args.length >= 3) {
        Object.keys(items._).forEach(function (key) {
          _forEachRecursive([
            callback,
            items._[key],
            key
          ].concat(args.slice(2)));
        });
      } else {
        Object.keys(items._).forEach(function (key) {
          _forEachRecursive([
            callback,
            items._[key],
            key
          ]);
        });
      }
    } else if (Array.isArray(items)) {
      callback.apply(null, [items].concat(args.slice(2)));
    }
  };
  /**
   * Iterate over all keys and values.
   * @param {function} callback Called with two arguments: values, key
   * @returns {undefined}
   */
  Table.prototype.forEach = function (callback) {
    _forEachRecursive([
      callback,
      this
    ]);
  };
  /**
   * Adds an object to a multi-dimension table. Head arguments are keys in order of deepness,
   * 1st goes highest key (e.g.: row key) and the one before last is the deepest level key (e.g.: column key).
   * Last argument considered as a value.
   *
   * @param arguments array of keys from top to bottom, ending with value (e.g.: [0] > rowKey, [1] > columnKey, [2] > value)
   */
  Table.prototype.add = function () {
    // selector, hasNone, callback
    var obj = this;
    // current level row
    var prev = null;
    // previous argument/key
    var cur = null;
    // current func argument/key/value
    for (var i = 0; i < arguments.length; i++) {
      cur = arguments[i];
      // then "obj" is an Array and "cur" is a value
      if (i === arguments.length - 1 && Array.isArray(obj)) {
        obj.push(cur);
        break;  // creating new level of table
      } else if (i < arguments.length - 2 && !obj._.hasOwnProperty(cur)) {
        obj._[cur] = new Table();  // {_: {}, length: 0}
                                   // considered as last level, we need to create an Array for values if not exists
      } else if (i === arguments.length - 2 && !obj._.hasOwnProperty(cur)) {
        obj._[cur] = [];
      }
      obj = obj._[cur];
      // this is an Array if i === arguments.length - 2
      prev = cur;
    }
  };
  /**
   *
   * @param visited an Array of tupples of "table key" > "object under that key" (root key is always null)
   * @param keyToRemove a key on the table structure which needs to be removed
   */
  var _cleanUpRecursive = function (visited, keyToRemove) {
    if (visited.length === 0) {
      return;
    }
    var tuple = visited.pop();
    var key = tuple[0];
    var obj = tuple[1];
    if (key === keyToRemove) {
      _cleanUpRecursive(visited, key);
    } else if (obj._.hasOwnProperty(keyToRemove)) {
      delete obj._[keyToRemove];
    }
    if (Object.keys(obj).length === 0) {
      _cleanUpRecursive(visited, key);
    }
  };
  /**
   * Remove an object under a key.
   * @param arguments array of keys from top to bottom, ending with value (e.g.: [0] > rowKey, [1] > columnKey, [2] > value)
   * @returns {boolean} true if an item was removed
   */
  Table.prototype.remove = function () {
    // e.g.: rowKey, columnKey, value
    var index;
    // index of the Array element that is about to be removed
    var mutated = false;
    // true if Table was changed, i.e. element was removed
    var key = null;
    // current level key
    var obj = this;
    // current level row
    // Visited elements - Array of tuples, root key is always null (e.g.: [aKey1, {_: { aKey2 : Table/Array }, length: 1}]
    var visited = [[
        key,
        obj
      ]];
    var cur = null;
    // current func argument
    for (var i = 0; i < arguments.length; i++) {
      cur = arguments[i];
      // then "obj" is Array and "cur" is an entry in this Array.
      if (Array.isArray(obj)) {
        index = obj.indexOf(cur);
        if (index > -1) {
          obj.splice(index, 1);
          if (obj.length === 0 && visited.length > 1) {
            _cleanUpRecursive(visited, key);  // cleaning all upper levels if they are empty as well
          }
          mutated = true;
        }
      } else if (obj._.hasOwnProperty(cur)) {
        // When only some key is specified, _all_ values under that key are removed.
        if (i === arguments.length - 1) {
          delete obj._[cur];
          // if we want correct reduce, we need to count all inner keys being removed
          if (Object.keys(obj).length === 0 && visited.length > 1) {
            _cleanUpRecursive(visited, key);  // cleaning all upper levels if they are empty either
          }
          mutated = true;
        }
        key = cur;
        obj = obj._[cur];
        visited.push([
          key,
          obj
        ]);  // at the previous to last index step obj is an Array
      } else {
        break;
      }
    }
    return mutated;
  };
  /**
   * Get objects under a key.
   * @returns {Array}
   * @param key under which sought-for element stored
   */
  Table.prototype.get = function (key) {
    if (this._.hasOwnProperty(key)) {
      return this._[key];
    }
    return [];
  };
  return Table;
}();
util_element_hound = function (document, Promise, Table, window) {
  var MutationObserver = window.MutationObserver;
  var observer;
  var observing = false;
  var targets;
  // MutationObserver -- Required for determining whether selectors are satisfied in the DOM;
  // Promise -- Required for combining multiple conditions together.
  if (!(MutationObserver && Promise)) {
    return;
  }
  // A table of selector -> [hasNone -> [callbacks, ...], ... ] of things to find.
  targets = new Table();
  function isNothing(obj) {
    return !obj || obj == null || obj === 'null' || obj === 'undefined';
  }
  /**
   * Add a target to watch for, ensuring the MutationObserver is enabled.
   * @param {string} selector
   * @param {string} hasNone
   * @param {function} callback
   */
  function addTarget(selector, hasNone, callback) {
    if (!observing) {
      observer.observe(document, {
        attributes: true,
        childList: true,
        subtree: true
      });
      observing = true;
    }
    targets.add(selector, hasNone, callback);
  }
  /**
   * Find candidate elements that satisfy the "selector predicate".
   * @param selector
   * @param hasNone
   * @returns {boolean}
   */
  function satisfies(selector, hasNone) {
    var candidates = document.querySelectorAll(selector);
    return candidates.length && (isNothing(hasNone) || Array.prototype.every.call(candidates, function (element) {
      return !element.querySelector(hasNone);
    }));
  }
  // A MutationObserver so we know when the DOM changes.
  observer = new MutationObserver(function () {
    // 1. Gather list of elements that satisfy the "selector" predicate
    // 2. For each of those "candidate" elements, check if it satisfies the "hasNone" predicate.
    targets.forEach(function (callbacks, hasNone, selector) {
      if (satisfies(selector, hasNone)) {
        callbacks.forEach(function (callback) {
          callback();
        });
        targets.remove(selector, hasNone);
      }
    });
  });
  /**
   * @typedef {Promise} ElementHound
   * @property {function} dismiss When called, dismissed the hound.
   */
  /**
   * Find some elements!
   *
   * @param {string|string[]} selectors One ore more CSS selectors that must all match elements of interest.
   * @param {string|string[]} hasNones If not null, selectors only match elements that do not have descendants matching
   *     this selector.
   * @returns {ElementHound}
   * @constructor
   */
  function ElementHound(selectors, hasNones) {
    var dismiss;
    // Normalise selectors to an array.
    if (!selectors.forEach) {
      selectors = [selectors];
    }
    // Join all "hasNones" into one big comma separated selector
    if (!isNothing(hasNones) && Array.isArray(hasNones)) {
      hasNones = hasNones.join(', ');
    }
    /**
     * @type {ElementHound}
     */
    var result = new Promise(function (resolve, reject) {
      var requirementPromises = [];
      var requirementCleanups = [];
      selectors.forEach(function (selector) {
        var promise;
        var clean;
        if (!satisfies(selector, hasNones)) {
          promise = new Promise(function (resolve) {
            addTarget(selector, hasNones, resolve);
            clean = function clean() {
              targets.remove(selector, hasNones, resolve);
            };
            requirementCleanups.push(clean);
          });
          requirementPromises.push(promise);
        }
      });
      // Clean-up after ourselves, to reduce the work done by the mutation observer.
      var cleanup = function cleanup() {
        requirementCleanups.forEach(function (clean) {
          clean();
        });
      };
      Promise.all(requirementPromises).then(cleanup).then(resolve, reject);
      dismiss = function dismiss() {
        cleanup();
        reject();
      };
    });
    // Allow the caller to explicitly dismiss the hound. This allows the caller to say
    // they don't care about the result any more, and allows us to stop looking for it.
    result.dismiss = dismiss;
    return result;
  }
  return ElementHound;
}(util_document, util_promise, util_table, util_window);
api_start_is_ready_supported = function (ElementHound) {
  /**
   * Feature detection for whether the .api({ready: …}) API option is supported.
   */
  return !!ElementHound;
}(util_element_hound);
util_request_immediate_paint = function (document) {
  var VISIBILITY_CHANGE = 'visibilitychange';
  var ANIMATION_END = 'animationend';
  var ANIMATION_CLASS_NAME = 'browser-metrics-visibility-test';
  var ANIMATION_NAME = 'browser-metrics-visibility-animation';
  var promise;
  /**
   * Ensure that the necessary CSS animation styles are on the page.
   */
  var requireCssOnce = function () {
    var element = document.createElement('style');
    var css = [
      '.' + ANIMATION_CLASS_NAME + ' {',
      // Using a value of 0 causes the animation not to run in Safari.
      '-webkit-animation-duration: 0.001s;',
      'animation-duration: 0.001s;',
      '-webkit-animation-name: ' + ANIMATION_NAME + ';',
      'animation-name: ' + ANIMATION_NAME + ';',
      '-webkit-animation-iteration-count: 1;',
      'animation-iteration-count: 1;',
      '}',
      '@keyframes ' + ANIMATION_NAME + ' {}',
      '@-webkit-keyframes ' + ANIMATION_NAME + ' {',
      'from {}',
      'to {}',
      '}'
    ].join('\n');
    element.type = 'text/css';
    if (element.styleSheet) {
      element.styleSheet.cssText = css;
    } else {
      element.appendChild(document.createTextNode(css));
    }
    document.head.appendChild(element);
    requireCssOnce = function () {
    };
  };
  /**
   * Queue the animation that we're going to use to determine when the screen is painted.
   */
  function queueAnimation() {
    requireCssOnce();
    document.body.classList.add(ANIMATION_CLASS_NAME);
  }
  /**
   * Return a promise that is resolved after the next paint.
   *
   * The term "immediate" is used to mean that the window *must be visible*. This is important as browsers are under
   * no obligation to render the page if the window or tab is hidden.
   *
   * The strategy of the implementation is to make use of CSS3 Animations to coerce the browser to emit an event
   * ("transitionend") after its next paint. This means that this only works on browsers that support CSS3 animations.
   *
   * @returns {window.Promise}
   */
  function requestImmediatePaint() {
    if (promise) {
      return promise;
    }
    var visibilityChanged = false;
    var onAnimationEnd;
    var onVisibilityChange;
    function cleanUp() {
      document.body.classList.remove(ANIMATION_CLASS_NAME);
      document.removeEventListener(VISIBILITY_CHANGE, onVisibilityChange);
      document.removeEventListener(ANIMATION_END, onAnimationEnd);
      promise = null;
    }
    promise = new Promise(function (resolve, reject) {
      if (document.visibilityState !== 'visible') {
        reject();
      } else {
        onVisibilityChange = function onVisibilityChange() {
          visibilityChanged = true;
        };
        onAnimationEnd = function onAnimationEnd(event) {
          if (event.animationName !== ANIMATION_NAME) {
            return;
          }
          // If the visibility changed while we were to be called back, it means the browser was hidden for
          // some time, which soils our measurements. In that scenario we just throw them away.
          if (visibilityChanged) {
            reject();
          } else {
            resolve();
          }
        };
        // It's necessary to watch for "visibilitychange" events to determine if the browser was hidden
        // *after* we began waiting for the animationend event..
        document.addEventListener(VISIBILITY_CHANGE, onVisibilityChange);
        document.addEventListener(ANIMATION_END, onAnimationEnd);
        queueAnimation();
      }
    });
    promise.then(cleanUp, cleanUp);
    return promise;
  }
  return requestImmediatePaint;
}(util_document);
api_find = function (isReadySupported, ElementHound, Promise, requestImmediatePaint, window) {
  /**
   * @typedef {(string|string[]|{selector: string, hasNone?: string|null}[])} FuzzyFindRules
   */
  /**
   * @typedef {{selector: string, hasNone: string|null}} FindRule
   */
  /**
   * @typedef {Array<FindRule>} FindRules
   */
  /**
   * @typedef {(FuzzyFindRules|{rules: FuzzyFindRules, requirePaint?: boolean})} FuzzyFindOptions
   */
  /**
   * In the .find() API, there are multiple short-hand versions of the 'conditions' value that can be used. In the
   * interest of sanity, this function normalises them all to the most complex form.
   *
   * @param {FuzzyFindRules} rules
   * @returns FindRules
   */
  function normalisedRules(rules) {
    if (!Array.isArray(rules)) {
      rules = [rules];
    }
    return rules.map(function (c) {
      return typeof c === 'string' ? {
        selector: c,
        hasNone: null
      } : c;
    });
  }
  /**
   * Determines if a value looks like a fuzzy rules value.
   *
   * @param {(*|FuzzyFindRules)} value
   * @returns {boolean}
   */
  function isFuzzyRules(value) {
    return Array.isArray(value) || typeof value === 'string';
  }
  /**
   * In the .find() API, there are multiple variants of the 'options' parameter that can be used. In the
   * interest of sanity, this function normalises them all to the most complex form.
   *
   * @param {FuzzyFindOptions} options
   * @returns {{rules: Rules, requirePaint: boolean}}
   */
  function normalisedOptions(options) {
    if (isFuzzyRules(options)) {
      options = { rules: options };
    }
    options.rules = normalisedRules(options.rules);
    options.requirePaint = typeof options.requirePaint === 'undefined' ? false : options.requirePaint;
    return options;
  }
  /**
   * @typedef {Promise} FindPromise
   * @property {function} cancel Stop looking for element. It will reject the Promise.
   */
  /**
   * Find an element in the DOM (potentially waiting indefinitely for it to arrive).
   *
   * @param {FuzzyFindOptions} [options] Options for describing find conditions. Conditions are CSS selectors that
   *     match one or more DOM elements. If hasNone is not null the Promise will be resolved only if matched elements
   *     do not have descendants matching hasNone selector. If *requirePaint* is true, the page must be visible (i.e.
   *     `document.visibilityState`) and a paint occur for the find to succeed. If the page is hidden the find will be
   *     aborted (i.e. never succeed).
   * @param {function} [callback] A callback that will get called when the CSS selector is matched. It is useful for
   *     browsers that does not support native promises yet.
   *
   * @returns {FindPromise}
   *
   * @example
   *     api.find([
   *             ".issue-main-content",
   *             {selector: ".issue-main-content", hasNone: ".loading"},
   *             ".another-required-thing"
   *     ], function() {
   *          performance.mark('issue.visible')
   *     });
   * @example
   *     api.find({
   *         rules: [
   *             ".issue-main-content",
   *             {selector: ".issue-main-content", hasNone: ".loading"},
   *             ".another-required-thing"
   *         ],
   *         requirePaint: true
   *     });
   */
  return function find(options, callback) {
    if (!isReadySupported) {
      return;
    }
    options = normalisedOptions(options);
    var cancel = function () {
    };
    var result = new Promise(function (resolve, reject) {
      var executeOnCancel = [];
      var promises = options.rules.map(function (rule) {
        var hound = new ElementHound(rule.selector, rule.hasNone);
        executeOnCancel.push(function () {
          hound.dismiss();
        });
        return hound;
      });
      cancel = function cancel() {
        executeOnCancel.forEach(function (callback) {
          callback();
        });
        reject();
      };
      Promise.all(promises).then(function (results) {
      }).then(resolve, reject);
    });
    result.cancel = cancel;
    if (options.requirePaint) {
      result = result.then(requestImmediatePaint);
    }
    if (typeof callback === 'function') {
      result.then(callback);
    }
    return result;
  };
}(api_start_is_ready_supported, util_element_hound, util_promise, util_request_immediate_paint, util_window);
util_is_dom_content_loaded_done = function (document, window) {
  var done = false;
  document.addEventListener('DOMContentLoaded', function () {
    // setTimeout matters here because the purpose of this module is to let know when all the DOMContentLoaded
    // event handlers have run. In order to know that, it would have to run after all the other handlers have run.
    // Hence we're using setTimeout to wait until the next tick. We know for certain that on the next tick all
    // the handlers have been executed due to JavaScript being single threaded.
    window.setTimeout(function () {
      done = true;
    });
  });
  /**
   * Return true if the DOMContentLoaded event handlers have been called.
   * @returns {boolean}
   */
  function isDOMContentLoadedDone() {
    return done;
  }
  return isDOMContentLoadedDone;
}(util_document, util_window);
api_start = function (find, end, isReadySupported, eventStream, isDOMContentLoadedDone, Promise, window) {
  var currentFind;
  function reset() {
    currentFind = null;
  }
  /**
   * Start measuring the duration of a transition.
   *
   * @param {String} options.key A key that identifies the page where the user is headed.
   * @param {boolean} [options.isInitial] If specified, indicates whether the transition should be treated as a
   *     "full page load" (initial). If not specified, this will be determined automatically based on whether or not
   *     DOMContentLoaded has fired.
   * @param {number} [options.threshold=1000] Declares the target (in milliseconds) duration for the navigation. The
   *     performance of the navigation is considered *good* if it completes within this threshold.
   * @param {String|String[]|{selector: string}[]} [options.ready] A CSS selector that matches
   *     one or more DOM elements. When the selector matches something in the DOM, the page is considered "ready" for
   *     the user.
   *
   *     For non-initial page loads, if the selector _immediately_ matches one or more elements in the DOM, it will
   *     first wait a matching element to be removed, and then wait for a DOM mutation to expose a matching element.
   *     This behaviour can be turned off (i.e. don't require an element to be removed first) via the option.
   * @param {Reporter|Reporter[]} [options.reporters] array of custom reporters that will get executed for this
   *      transition. Custom reporters are executed in order after default reporters.
   *
   * @returns {undefined}
   * @example
   *     api.start({key: "jira.issue.view"});
   * @example
   *     api.start({
   *         key: "jira.issue.view",
   *         threshold: 1000
   *     });
   * @example
   *     api.start({
   *         key: "jira.issue.view",
   *         reporters: function(transition) {
   *              return { projectCentric: true}
   *         }
   *     });
   * @example
   *     api.start({
   *         key: "jira.issue.view",
   *         ready: ".issue-main-content",
   *         threshold: 1000
   *     });
   * @example
   *     api.start({
   *         key: "jira.issue.view",
   *         ready: [
   *             ".issue-main-content",
   *             {selector: ".issue-main-content", hasNone: ".loading"},
   *             ".another-required-thing"
   *         ],
   *         threshold: 1000
   *     });
   * @example
   *     api.start({
   *         key: "jira.issue.view",
   *         ready: {
   *             rules: [
   *                 ".issue-main-content",
   *                 {selector: ".issue-main-content", hasNone: ".loading"},
   *                 ".another-required-thing"
   *             ],
   *             requirePaint: true
   *         },
   *         threshold: 1000
   *     });
   */
  return function start(options) {
    var conditions;
    var findPromise;
    var isInitial = 'isInitial' in options ? options.isInitial : isDOMContentLoadedDone() === false;
    var threshold = 'threshold' in options ? options.threshold : 1000;
    var reporters = 'reporters' in options ? options.reporters : [];
    eventStream.push({
      start: {
        key: options.key,
        isInitial: isInitial,
        threshold: threshold,
        timestamp: isInitial ? 0 : window.performance.now(),
        reporters: Array.isArray(reporters) ? reporters : [reporters]
      }
    });
    if (currentFind) {
      currentFind.cancel();
      reset();
    }
    if (options.ready && isReadySupported) {
      currentFind = find(options.ready);
      currentFind.then(function () {
        end({ key: options.key });
      }).then(reset, reset);
    }
  };
}(api_find, api_end, api_start_is_ready_supported, event_stream, util_is_dom_content_loaded_done, util_promise, util_window);
api_subscribe = function (eventStream) {
  /**
   * Add a subscriber that's interested in reports.
   */
  return function subscribe(subscriber) {
    eventStream.push({ subscribe: subscriber });
  };
}(event_stream);
index = function (isSupported, addReporter, delegateTo, end, start, subscribe) {
  var noop = function () {
  };
  return {
    start: isSupported ? start : noop,
    end: isSupported ? end : noop,
    addReporter: isSupported ? addReporter : noop,
    delegateTo: isSupported ? delegateTo : noop,
    subscribe: isSupported ? subscribe : noop
  };
}(is_supported, api_addReporter, api_delegateTo, api_end, api_start, api_subscribe);
window['browser-metrics'] = index;
if (window.define) {
  window.define('internal/browser-metrics', function () {
    return index;
  });
}
}());