/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.tasks;

import com.atlassian.annotations.Internal;
import com.atlassian.plugins.hipchat.tasks.HipChatTasksExecutor;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Internal
public class DefaultHipChatTasksExecutor
implements DisposableBean,
HipChatTasksExecutor {
    private ListeningScheduledExecutorService executorService;
    private static final Logger logger = LoggerFactory.getLogger(DefaultHipChatTasksExecutor.class);

    public DefaultHipChatTasksExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("hipchat-plugin-tasks-executor-%d").build();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.executorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)executor);
    }

    @Override
    public ListeningScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public <T> Promise<T> submit(Callable<T> task) {
        return Promises.forListenableFuture((ListenableFuture)this.executorService.submit(task));
    }

    @Override
    public Promise<?> submit(Runnable task) {
        return Promises.forListenableFuture((ListenableFuture)this.executorService.submit(task));
    }

    @Override
    public <V> Promise<V> schedule(final Callable<V> task, long delay, TimeUnit unit) {
        final SettableFuture future = SettableFuture.create();
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    Object result = task.call();
                    future.set(result);
                }
                catch (Throwable ex) {
                    future.setException(ex);
                }
            }
        }, delay, unit);
        return Promises.forListenableFuture((ListenableFuture)future);
    }

    @Override
    public Promise<?> schedule(final Runnable task, long delay, TimeUnit unit) {
        final SettableFuture future = SettableFuture.create();
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                    future.set(null);
                }
                catch (Throwable ex) {
                    future.setException(ex);
                }
            }
        }, delay, unit);
        return Promises.forListenableFuture((ListenableFuture)future);
    }

    public void destroy() throws Exception {
        this.shutdown();
    }

    private void shutdown() {
        List remainingTasks = this.executorService.shutdownNow();
        if (remainingTasks.size() > 0) {
            logger.info("Executor service shutting, {} pending tasks were cancelled.", (Object)remainingTasks.size());
        }
    }
}

