/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.client;

import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyingHttpURLConnectionFactory
implements HttpURLConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(ProxyingHttpURLConnectionFactory.class);

    public ProxyingHttpURLConnectionFactory() {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                    String protocol = this.getRequestingProtocol().toLowerCase();
                    String hostname = System.getProperty(protocol + ".proxyHost");
                    if (StringUtils.equalsIgnoreCase((String)this.getRequestingHost(), (String)hostname)) {
                        String username = System.getProperty(protocol + ".proxyUser", "");
                        String password = System.getProperty(protocol + ".proxyPassword", "");
                        return new PasswordAuthentication(username, password.toCharArray());
                    }
                }
                return null;
            }
        });
    }

    public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
        ProxySelector proxySelector = ProxySelector.getDefault();
        Proxy proxy = Proxy.NO_PROXY;
        try {
            URI uri = url.toURI();
            List<Proxy> proxies = proxySelector.select(uri);
            proxy = proxies.size() > 0 ? proxies.get(0) : Proxy.NO_PROXY;
        }
        catch (URISyntaxException e) {
            logger.info("Couldn't convert URL " + url + " to URI. Using no proxy for it.");
        }
        return (HttpURLConnection)url.openConnection(proxy);
    }
}

