/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.groups;

import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;

public enum PlanType {
    UNKNOWN("unknown"),
    FREE("free"),
    TRIAL("trial"),
    PLUS("plus"),
    PREMIUM("premium"),
    NON_PROFIT("non_profit");

    private final String hipChatApiValue;

    private PlanType(String hipChatApiValue) {
        this.hipChatApiValue = hipChatApiValue;
    }

    public String getHipChatApiValue() {
        return this.hipChatApiValue;
    }

    public String toString() {
        return this.getHipChatApiValue();
    }

    @JsonCreator
    public static PlanType parseFromHipChatApiValue(String apiValue) {
        for (PlanType planType : PlanType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)planType.getHipChatApiValue(), (CharSequence)StringUtils.trimToEmpty((String)apiValue))) continue;
            return planType;
        }
        return UNKNOWN;
    }
}

