/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api;

import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.ErrorResponse;
import com.atlassian.hipchat.api.ResourceError;
import com.atlassian.hipchat.api.Result;
import com.google.common.base.Function;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientResponseMapper
implements ClientResponseMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClientResponseMapper.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Override
    public <T> Function<ClientResponse, Result<T>> to(final Class<? extends T> clazz) {
        final Option cause = LOGGER.isDebugEnabled() ? Option.some((Object)new Throwable()) : Option.none();
        return new Function<ClientResponse, Result<T>>(){

            public Result<T> apply(ClientResponse input) {
                if (DefaultClientResponseMapper.notSuccessStatus(input)) {
                    return Result.error(DefaultClientResponseMapper.makeResourceError(input, (Option<Throwable>)cause, clazz));
                }
                return Result.success(input.getEntity(clazz));
            }
        };
    }

    @Override
    public <T> Function<ClientResponse, Result.CacheableResult<T>> conditionalTo(final Class<T> clazz) {
        final Option cause = LOGGER.isDebugEnabled() ? Option.some((Object)new Throwable()) : Option.none();
        return new Function<ClientResponse, Result.CacheableResult<T>>(){

            public Result.CacheableResult<T> apply(ClientResponse input) {
                if (DefaultClientResponseMapper.isNotModifiedStatus(input)) {
                    return Result.CacheableResult.notModified();
                }
                if (DefaultClientResponseMapper.notSuccessStatus(input)) {
                    return Result.CacheableResult.fromResult(Result.error(DefaultClientResponseMapper.makeResourceError(input, (Option<Throwable>)cause, clazz)));
                }
                String etagHeader = (String)input.getHeaders().getFirst((Object)"ETag");
                return Result.CacheableResult.success(input.getEntity(clazz), (Option<String>)Option.option((Object)etagHeader));
            }
        };
    }

    @Override
    public Function<ClientResponse, Result<Void>> toVoid() {
        final Option cause = LOGGER.isDebugEnabled() ? Option.some((Object)new Throwable()) : Option.none();
        return new Function<ClientResponse, Result<Void>>(){

            public Result<Void> apply(ClientResponse input) {
                if (DefaultClientResponseMapper.notSuccessStatus(input)) {
                    return Result.error(DefaultClientResponseMapper.makeResourceError(input, (Option<Throwable>)cause, Void.class));
                }
                return Result.successVoid();
            }
        };
    }

    private static boolean notSuccessStatus(ClientResponse input) {
        return input.getStatus() < Response.Status.OK.getStatusCode() || input.getStatus() >= Response.Status.BAD_REQUEST.getStatusCode();
    }

    private static boolean isNotModifiedStatus(ClientResponse input) {
        return input.getStatus() == Response.Status.NOT_MODIFIED.getStatusCode();
    }

    private static <T> ResourceError makeResourceError(ClientResponse input, Option<Throwable> cause, Class<T> clazz) {
        String inputString = (String)input.getEntity(String.class);
        try {
            ErrorResponse errorResponse = (ErrorResponse)OBJECT_MAPPER.readValue(inputString, ErrorResponse.class);
            return new ResourceError(errorResponse);
        }
        catch (Exception e) {
            String logMessage = String.format("Can't convert response to [%s]: %s", clazz.getName(), inputString);
            if (cause.isDefined()) {
                LOGGER.debug(logMessage, cause);
            } else {
                LOGGER.debug(logMessage);
            }
            String errorMessage = String.format("Resource error - %d: %s", input.getStatus(), input.getClientResponseStatus().getReasonPhrase());
            return new ResourceError(new Exception(errorMessage, (Throwable)cause.getOrNull()), input.getStatus());
        }
    }

    @Override
    public <T> Function<ClientResponse, Result<T>> to(final GenericType<? extends T> type) {
        final Option cause = LOGGER.isDebugEnabled() ? Option.some((Object)new Throwable()) : Option.none();
        return new Function<ClientResponse, Result<T>>(){

            public Result<T> apply(ClientResponse input) {
                if (DefaultClientResponseMapper.notSuccessStatus(input)) {
                    return Result.error(DefaultClientResponseMapper.makeResourceError(input, (Option<Throwable>)cause, type.getRawClass()));
                }
                return Result.success(input.getEntity(type));
            }
        };
    }
}

