// node_modules/skatejs/lib/document-observer.js
(typeof window === 'undefined' ? global : window).__3c8c6233f9ea85a9125bd2a1e04f063c = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  var defineDependencies = {
    "module": module,
    "exports": exports,
    "./globals": __df73b283f1d40e8f4912fb904e42aa12,
    "./lifecycle": __76ada509bc46d5c68cd543ddd8e839a4,
    "./mutation-observer": __c91177d0507115b2c279ac28adb63576,
    "./fix-ie-innerhtml": __576655637d4ea6523fc9a23f8a7b3b68,
    "./utils": __c962c88861b22faa9e6b0ff498553ca3,
    "./globals": __df73b283f1d40e8f4912fb904e42aa12,
    "./lifecycle": __76ada509bc46d5c68cd543ddd8e839a4,
    "./mutation-observer": __c91177d0507115b2c279ac28adb63576,
    "./fix-ie-innerhtml": __576655637d4ea6523fc9a23f8a7b3b68,
    "./utils": __c962c88861b22faa9e6b0ff498553ca3
  };
  var define = function defineReplacementWrapper(generatedModuleName) {
    return function defineReplacement(name, deps, func) {
      var root = (typeof window === 'undefined' ? global : window);
      var defineGlobal = root.define;
      var rval;
      var type;
  
      func = [func, deps, name].filter(function (cur) {
        return typeof cur === 'function';
      })[0];
      deps = [deps, name, []].filter(Array.isArray)[0];
      rval = func.apply(null, deps.map(function (value) {
        return defineDependencies[value];
      }));
      type = typeof rval;
  
      // Support existing AMD libs.
      if (typeof defineGlobal === 'function') {
        // Almond always expects a name so resolve one (#29).
        defineGlobal(typeof name === 'string' ? name : generatedModuleName, deps, func);
      }
  
      // Some processors like Babel don't check to make sure that the module value
      // is not a primitive before calling Object.defineProperty() on it. We ensure
      // it is an instance so that it can.
      if (type === 'string') {
        rval = String(rval);
      } else if (type === 'number') {
        rval = Number(rval);
      } else if (type === 'boolean') {
        rval = Boolean(rval);
      }
  
      // Reset the exports to the defined module. This is how we convert AMD to
      // CommonJS and ensures both can either co-exist, or be used separately. We
      // only set it if it is not defined because there is no object representation
      // of undefined, thus calling Object.defineProperty() on it would fail.
      if (rval !== undefined) {
        exports = module.exports = rval;
      }
    };
  }("__3c8c6233f9ea85a9125bd2a1e04f063c");
  define.amd = true;
  
  (function (factory) {
    if (typeof define === "function" && define.amd) {
      define(["exports", "module", "./globals", "./lifecycle", "./mutation-observer", "./fix-ie-innerhtml", "./utils"], factory);
    } else if (typeof exports !== "undefined" && typeof module !== "undefined") {
      factory(exports, module, __df73b283f1d40e8f4912fb904e42aa12, __76ada509bc46d5c68cd543ddd8e839a4, __c91177d0507115b2c279ac28adb63576, __576655637d4ea6523fc9a23f8a7b3b68, __c962c88861b22faa9e6b0ff498553ca3);
    }
  })(function (exports, module, _globals, _lifecycle, _mutationObserver, _fixIeInnerhtml, _utils) {
  
    var _interopRequire = function (obj) { return obj && obj.__esModule ? obj["default"] : obj; };
  
    var globals = _interopRequire(_globals);
  
    var initElements = _lifecycle.initElements;
    var removeElements = _lifecycle.removeElements;
    var getClosestIgnoredElement = _utils.getClosestIgnoredElement;
  
    /**
     * The document observer handler.
     *
     * @param {Array} mutations The mutations to handle.
     *
     * @returns {undefined}
     */
    function documentObserverHandler(mutations) {
      var mutationsLen = mutations.length;
  
      for (var a = 0; a < mutationsLen; a++) {
        var mutation = mutations[a];
        var addedNodes = mutation.addedNodes;
        var removedNodes = mutation.removedNodes;
  
        // Since siblings are batched together, we check the first node's parent
        // node to see if it is ignored. If it is then we don't process any added
        // nodes. This prevents having to check every node.
        if (addedNodes && addedNodes.length && !getClosestIgnoredElement(addedNodes[0].parentNode)) {
          initElements(addedNodes);
        }
  
        // We can't check batched nodes here because they won't have a parent node.
        if (removedNodes && removedNodes.length) {
          removeElements(removedNodes);
        }
      }
    }
  
    /**
     * Creates a new mutation observer for listening to Skate definitions for the
     * document.
     *
     * @param {Element} root The element to observe.
     *
     * @returns {MutationObserver}
     */
    function createDocumentObserver() {
      var observer = new window.MutationObserver(documentObserverHandler);
  
      // Observe after the DOM content has loaded.
      observer.observe(document, {
        childList: true,
        subtree: true
      });
  
      return observer;
    }
  
    module.exports = {
      register: function register(fixIe) {
        // IE has issues with reporting removedNodes correctly. See the polyfill for
        // details. If we fix IE, we must also re-define the document observer.
        if (fixIe) {
          this.unregister();
        }
  
        if (!globals.observer) {
          globals.observer = createDocumentObserver();
        }
  
        return this;
      },
  
      unregister: function unregister() {
        if (globals.observer) {
          globals.observer.disconnect();
          globals.observer = undefined;
        }
  
        return this;
      }
    };
  });
  
  return module.exports;
}).call(this);