// node_modules/@atlassian/aui/src/js/aui/progress-indicator.js
(typeof window === 'undefined' ? global : window).__cb31fb29564cb1430c38ca8ab010b61f = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  
  'use strict';
  
  Object.defineProperty(exports, "__esModule", {
      value: true
  });
  
  var _jquery = __307d3e18fd611f85395c67cddeb1fe24;
  
  var _jquery2 = _interopRequireDefault(_jquery);
  
  var _animation = __c0311e8841bd8637e025a8fb1474f693;
  
  var _globalize = __4d02fe17b8e885a34493e34af3d145dd;
  
  var _globalize2 = _interopRequireDefault(_globalize);
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
  
  function updateProgress($progressBar, $progressBarContainer, progressValue) {
      (0, _animation.recomputeStyle)($progressBar);
      $progressBar.css('width', progressValue * 100 + '%');
      $progressBarContainer.attr('data-value', progressValue);
  }
  
  var progressBars = {
      update: function update(element, value) {
          var $progressBarContainer = (0, _jquery2.default)(element).first();
          var $progressBar = $progressBarContainer.children('.aui-progress-indicator-value');
          var valueAttribute = $progressBarContainer.attr('data-value');
          var currentProgress = parseFloat(valueAttribute) || 0;
          var isProgressNotChanged = valueAttribute && currentProgress === value;
  
          if (isProgressNotChanged) {
              return;
          }
  
          var afterTransitionEvent = 'aui-progress-indicator-after-update';
          var beforeTransitionEvent = 'aui-progress-indicator-before-update';
          var transitionEnd = 'transitionend webkitTransitionEnd';
  
          var isIndeterminate = !valueAttribute;
  
          //if the progress bar is indeterminate switch it.
          if (isIndeterminate) {
              $progressBar.css('width', 0);
          }
  
          if (typeof value === 'number' && value <= 1 && value >= 0) {
              $progressBarContainer.trigger(beforeTransitionEvent, [currentProgress, value]);
  
              //detect whether transitions are supported
              var documentBody = document.body || document.documentElement;
              var style = documentBody.style;
              var isTransitionSupported = typeof style.transition === 'string' || typeof style.WebkitTransition === 'string';
  
              //trigger the event after transition end if supported, otherwise just trigger it
              if (isTransitionSupported) {
                  $progressBar.one(transitionEnd, function () {
                      $progressBarContainer.trigger(afterTransitionEvent, [currentProgress, value]);
                  });
                  updateProgress($progressBar, $progressBarContainer, value);
              } else {
                  updateProgress($progressBar, $progressBarContainer, value);
                  $progressBarContainer.trigger(afterTransitionEvent, [currentProgress, value]);
              }
          }
          return $progressBarContainer;
      },
  
      setIndeterminate: function setIndeterminate(element) {
          var $progressBarContainer = (0, _jquery2.default)(element).first();
          var $progressBar = $progressBarContainer.children('.aui-progress-indicator-value');
  
          $progressBarContainer.removeAttr('data-value');
          (0, _animation.recomputeStyle)($progressBarContainer);
          $progressBar.css('width', '100%');
      }
  };
  
  (0, _globalize2.default)('progressBars', progressBars);
  
  exports.default = progressBars;
  module.exports = exports['default'];
  
  return module.exports;
}).call(this);