// node_modules/@atlassian/aui/src/js/aui/label.js
(typeof window === 'undefined' ? global : window).__f5b87d288f6252359b1ecd0c6cf5783d = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  
  'use strict';
  
  Object.defineProperty(exports, "__esModule", {
      value: true
  });
  
  var _skate = __c1ce1f1e3e613f564fc234ff043570f1;
  
  var _skate2 = _interopRequireDefault(_skate);
  
  var _skatejsTemplateHtml = __f52b7059926ab2bdcd0aee12b4bc782b;
  
  var _skatejsTemplateHtml2 = _interopRequireDefault(_skatejsTemplateHtml);
  
  var _enforcer = __8339408c10b0a9052af9f3aad7b3a4e8;
  
  var _enforcer2 = _interopRequireDefault(_enforcer);
  
  var _constants = __fa2d609d3773596cc2b702b68678a39c;
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
  
  function getLabel(element) {
      return element.querySelector('label');
  }
  
  function updateLabelFor(element, change) {
      if (element.hasAttribute('for')) {
          getLabel(element).setAttribute('for', '' + change.newValue + _constants.INPUT_SUFFIX);
      } else {
          getLabel(element).removeAttribute('for');
      }
  }
  
  function updateLabelForm(element, change) {
      if (element.hasAttribute('form')) {
          getLabel(element).setAttribute('form', change.newValue);
      } else {
          getLabel(element).removeAttribute('form');
      }
  }
  
  var Label = (0, _skate2.default)('aui-label', {
      template: (0, _skatejsTemplateHtml2.default)('<label><content></content></label>'),
      created: function created(element) {
          element._label = getLabel(element); // required for quick access from test
      },
      attached: function attached(element) {
          (0, _enforcer2.default)(element).attributeExists('for');
      },
      attributes: {
          'for': updateLabelFor,
          form: updateLabelForm
      },
      prototype: {
          get disabled() {
              return this.hasAttribute('disabled');
          },
          set disabled(value) {
              if (value) {
                  this.setAttribute('disabled', '');
              } else {
                  this.removeAttribute('disabled');
              }
          }
      },
      events: {
          click: function click(element, e) {
              if (element.disabled) {
                  e.preventDefault();
              }
          }
      }
  });
  
  exports.default = Label;
  module.exports = exports['default'];
  
  return module.exports;
}).call(this);