// node_modules/@atlassian/aui/src/js/aui/binders/placeholder.js
(typeof window === 'undefined' ? global : window).__6b53202d7e5920f946b3003fd2037f67 = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  
  'use strict';
  
  var _jquery = __307d3e18fd611f85395c67cddeb1fe24;
  
  var _jquery2 = _interopRequireDefault(_jquery);
  
  var _binder = __6160ee95bf90760449be557c1758e3db;
  
  var _binder2 = _interopRequireDefault(_binder);
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
  
  (function () {
      // browser supports placeholder, no need to do anything
      var temp = document.createElement('input');
  
      if ('placeholder' in temp) {
          return;
      }
  
      /**
       * Displays default text in the input field when its value is empty.
       * If the browser supports placeholder input attributes (HTML5), then
       * we skip this component.
       *
       * Usage:
       * <pre>
       * &lt;input placeholder='Some default text'&gt;
       * </pre>
       *
       * Events thrown: reset.placeholder
       */
      _binder2.default.register('placeholder', {
          selector: 'input[placeholder]',
          run: function run(element) {
              var $this = (0, _jquery2.default)(element);
              var applyDefaultText = function applyDefaultText() {
                  if (!_jquery2.default.trim($this.val()).length) {
                      $this.val($this.attr('placeholder')).addClass('placeholder-shown').trigger('reset.placeholder');
                  }
              };
  
              applyDefaultText();
              $this.blur(applyDefaultText).focus(function () {
                  if ($this.hasClass('placeholder-shown')) {
                      $this.val('').removeClass('placeholder-shown');
                  }
              });
          }
      });
  })();
  
  return module.exports;
}).call(this);