// node_modules/@atlassian/aui/src/js-vendor/raf/raf.js
(typeof window === 'undefined' ? global : window).__0e57a5ff611a3173e3f9aa2306aea259 = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  
  /*
   * raf.js
   * https://github.com/ngryman/raf.js
   *
   * original requestAnimationFrame polyfill by Erik Möller
   * inspired from paul_irish gist and post
   *
   * Copyright (c) 2013 ngryman
   * Licensed under the MIT license.
   */
  
  (function(window) {
  	var lastTime = 0,
  		vendors = ['webkit', 'moz'],
  		requestAnimationFrame = window.requestAnimationFrame,
  		cancelAnimationFrame = window.cancelAnimationFrame,
  		i = vendors.length;
  
  	// try to un-prefix existing raf
  	while (--i >= 0 && !requestAnimationFrame) {
  		requestAnimationFrame = window[vendors[i] + 'RequestAnimationFrame'];
  		cancelAnimationFrame = window[vendors[i] + 'CancelAnimationFrame'];
  	}
  
  	// polyfill with setTimeout fallback
  	// heavily inspired from @darius gist mod: https://gist.github.com/paulirish/1579671#comment-837945
  	if (!requestAnimationFrame || !cancelAnimationFrame) {
  		requestAnimationFrame = function(callback) {
  			var now = Date.now(), nextTime = Math.max(lastTime + 16, now);
  			return setTimeout(function() {
  				callback(lastTime = nextTime);
  			}, nextTime - now);
  		};
  
  		cancelAnimationFrame = clearTimeout;
  	}
  
  	// export to window
  	window.requestAnimationFrame = requestAnimationFrame;
  	window.cancelAnimationFrame = cancelAnimationFrame;
  }(window));
  
  return module.exports;
}).call(this);