/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.cors;

import com.atlassian.plugins.rest.common.security.CorsHeaders;
import com.atlassian.plugins.rest.common.security.descriptor.CorsDefaults;
import com.atlassian.plugins.whitelist.InboundWhitelist;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class WhitelistBasedCorsDefaults
implements CorsDefaults {
    private final InboundWhitelist inboundWhitelist;

    public WhitelistBasedCorsDefaults(InboundWhitelist inboundWhitelist) {
        this.inboundWhitelist = inboundWhitelist;
    }

    public boolean allowsCredentials(String origin) throws IllegalArgumentException {
        return this.allowsOrigin(origin);
    }

    public boolean allowsOrigin(String origin) throws IllegalArgumentException {
        URI originUri;
        if (StringUtils.isBlank((String)origin)) {
            return false;
        }
        try {
            originUri = new URI(origin);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return this.inboundWhitelist.isAllowed(originUri);
    }

    public Set<String> getAllowedRequestHeaders(String origin) throws IllegalArgumentException {
        return ImmutableSet.of((Object)"Content-Type", (Object)"X-Atlassian-Token");
    }

    public Set<String> getAllowedResponseHeaders(String origin) throws IllegalArgumentException {
        return ImmutableSet.of((Object)CorsHeaders.ORIGIN.value());
    }
}

