/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.spi.provider;

import com.atlassian.webhooks.spi.provider.EventSerializationException;
import com.atlassian.webhooks.spi.provider.EventSerializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public final class EventSerializers {
    private EventSerializers() {
    }

    public static EventSerializer reflection(Object event) {
        return new ReflectionEventSerializer(event);
    }

    public static EventSerializer forMap(Object event, Map<String, Object> data) {
        return new MapEventSerializer(event, data);
    }

    static final class ReflectionEventSerializer
    implements EventSerializer {
        private static final Set<Class<?>> RAW_TYPES = ImmutableSet.builder().add(Boolean.TYPE).add(Boolean.class).add(Byte.TYPE).add(Byte.class).add(Short.TYPE).add(Short.class).add(Integer.TYPE).add(Integer.class).add(Long.TYPE).add(Long.class).add(Float.TYPE).add(Float.class).add(Double.TYPE).add(Double.class).add(Character.TYPE).add(Character.class).add(String.class).build();
        private final Object event;

        ReflectionEventSerializer(Object event) {
            this.event = Preconditions.checkNotNull((Object)event);
        }

        @Override
        public Object getEvent() {
            return this.event;
        }

        @Override
        public String getWebHookBody() throws EventSerializationException {
            return EventSerializers.forMap(this.event, ReflectionEventSerializer.toMap(this.event)).getWebHookBody();
        }

        @VisibleForTesting
        static Map<String, Object> toMap(Object object) {
            Field[] fields;
            if (object == null) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                Object value = ReflectionEventSerializer.getValue(field, object);
                if (value == null) continue;
                builder.put((Object)field.getName(), value);
            }
            return builder.build();
        }

        private static Object getValue(Field field, Object object) {
            return ReflectionEventSerializer.getTransformedValue(ReflectionEventSerializer.getRawValue(field, object));
        }

        private static Object getTransformedValue(Object object) {
            if (object == null) {
                return null;
            }
            if (RAW_TYPES.contains(object.getClass())) {
                return object;
            }
            if (Iterable.class.isAssignableFrom(object.getClass())) {
                return Iterables.transform((Iterable)((Iterable)object), (Function)new Function<Object, Object>(){

                    public Object apply(@Nullable Object input) {
                        return ReflectionEventSerializer.getTransformedValue(input);
                    }
                });
            }
            return ReflectionEventSerializer.toMap(object);
        }

        private static Object getRawValue(Field field, Object object) {
            boolean isFieldAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                Object object2 = field.get(object);
                return object2;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Should not happen", e);
            }
            finally {
                field.setAccessible(isFieldAccessible);
            }
        }
    }

    private static final class MapEventSerializer
    implements EventSerializer {
        private final Object event;
        private final Map<String, Object> data;

        public MapEventSerializer(Object event, Map<String, Object> data) {
            this.event = event;
            this.data = data;
        }

        @Override
        public Object getEvent() {
            return this.event;
        }

        @Override
        public String getWebHookBody() {
            try {
                return new JSONObject(this.data).toString(2);
            }
            catch (JSONException e) {
                throw new EventSerializationException(e);
            }
        }
    }
}

