/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.web;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webhooks.plugin.web.AdminPageContextBuilder;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebHookAdminServlet
extends HttpServlet {
    private static final String WEBHOOKS_ADMIN_TEMPLATE_PATH = "templates/webhooks-admin.vm";
    private static final String NO_ADMIN_PRIVILEGES_TEMPLATE_PATH = "templates/no_admin_privileges.vm";
    private static final String TEXT_HTML_CHARSET_UTF_8 = "text/html; charset=utf-8";
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final WebSudoManager webSudoManager;
    private final AdminPageContextBuilder contextBuilder;

    public WebHookAdminServlet(TemplateRenderer templateRenderer, UserManager userManager, WebSudoManager webSudoManager, AdminPageContextBuilder contextBuilder) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.webSudoManager = webSudoManager;
        this.contextBuilder = contextBuilder;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
            if (this.userManager.isAdmin(this.userManager.getRemoteUserKey()) || this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey())) {
                this.render(resp);
            } else {
                this.renderNoAdminPrivileges(resp);
            }
        }
        catch (WebSudoSessionException wse) {
            this.webSudoManager.enforceWebSudoProtection(req, resp);
        }
    }

    private void renderNoAdminPrivileges(HttpServletResponse response) throws IOException {
        response.setContentType(TEXT_HTML_CHARSET_UTF_8);
        response.setStatus(403);
        this.templateRenderer.render(NO_ADMIN_PRIVILEGES_TEMPLATE_PATH, (Writer)response.getWriter());
    }

    private void render(HttpServletResponse response) throws IOException {
        response.setContentType(TEXT_HTML_CHARSET_UTF_8);
        this.templateRenderer.render(WEBHOOKS_ADMIN_TEMPLATE_PATH, this.contextBuilder.buildContext(), (Writer)response.getWriter());
    }
}

