/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.web;

import com.atlassian.webhooks.api.document.ProvidesUrlVariables;
import com.atlassian.webhooks.api.register.RegisteredWebHookEvent;
import com.atlassian.webhooks.api.register.WebHookEventGroup;
import com.atlassian.webhooks.api.register.WebHookEventSection;
import com.atlassian.webhooks.plugin.module.WebHookPluginRegistrationContainer;
import com.atlassian.webhooks.spi.DocumentedUriVariablesProvider;
import com.atlassian.webhooks.spi.UriVariablesProvider;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class UriVariablesProviderPageContextResolver {
    private final WebHookPluginRegistrationContainer webHookPluginRegistrationContainer;

    @Autowired
    public UriVariablesProviderPageContextResolver(WebHookPluginRegistrationContainer webHookPluginRegistrationContainer) {
        this.webHookPluginRegistrationContainer = webHookPluginRegistrationContainer;
    }

    public Map<String, Collection<String>> uriVariablesForWebhooks() {
        TreeMap result = Maps.newTreeMap();
        for (RegisteredWebHookEvent webhook : this.webHookPluginRegistrationContainer.getAllWebhooks()) {
            result.put(webhook.getId(), Sets.newTreeSet());
            Iterable<UriVariablesProvider> uriVariablesProviders = this.webHookPluginRegistrationContainer.getUriVariablesProviders().allForType(webhook.getEventClass());
            for (UriVariablesProvider provider : uriVariablesProviders) {
                ((Collection)result.get(webhook.getId())).addAll(UriVariablesProviderPageContextResolver.toDocumentedVariablesProvider(provider).providedVariables());
            }
        }
        return result;
    }

    public List<String> allUriVariables() {
        TreeSet result = Sets.newTreeSet();
        Set<String> visibleWebhooks = this.getVisibleWebhooks();
        for (Map.Entry<String, Collection<String>> entry : this.uriVariablesForWebhooks().entrySet()) {
            String webhookId = entry.getKey();
            if (!visibleWebhooks.contains(webhookId)) continue;
            result.addAll(entry.getValue());
        }
        return Lists.newArrayList((Iterable)result);
    }

    private static <T> DocumentedUriVariablesProvider<T> toDocumentedVariablesProvider(final UriVariablesProvider<T> variablesProvider) {
        if (variablesProvider instanceof DocumentedUriVariablesProvider) {
            return (DocumentedUriVariablesProvider)variablesProvider;
        }
        return new DocumentedUriVariablesProvider<T>(){

            @Override
            public Collection<String> providedVariables() {
                return UriVariablesProviderPageContextResolver.getProvidedVariablesFromAnnotation(variablesProvider);
            }

            @Override
            public Map<String, Object> uriVariables(T event) {
                return variablesProvider.uriVariables(event);
            }
        };
    }

    private static <T> Collection<String> getProvidedVariablesFromAnnotation(UriVariablesProvider<T> variablesProvider) {
        ProvidesUrlVariables annotation = variablesProvider.getClass().getAnnotation(ProvidesUrlVariables.class);
        if (annotation == null) {
            for (Method method : variablesProvider.getClass().getMethods()) {
                if (!method.isAnnotationPresent(ProvidesUrlVariables.class)) continue;
                return Lists.newArrayList((Object[])method.getAnnotation(ProvidesUrlVariables.class).value());
            }
            return Collections.emptySet();
        }
        return Lists.newArrayList((Object[])annotation.value());
    }

    private Set<String> getVisibleWebhooks() {
        HashSet result = Sets.newHashSet();
        for (WebHookEventSection section : this.webHookPluginRegistrationContainer.getWebHookSections()) {
            if (Strings.isNullOrEmpty((String)section.getNameI18nKey())) continue;
            for (WebHookEventGroup webHookEventGroup : Iterables.filter(section.getGroups(), (Predicate)new Predicate<WebHookEventGroup>(){

                public boolean apply(WebHookEventGroup input) {
                    return !Strings.isNullOrEmpty((String)input.getNameI18nKey());
                }
            })) {
                result.addAll(Lists.transform(webHookEventGroup.getEvents(), (Function)new Function<RegisteredWebHookEvent, String>(){

                    public String apply(RegisteredWebHookEvent input) {
                        return input.getId();
                    }
                }));
            }
        }
        return result;
    }
}

